/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.PreinstallOperation;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.welcome.WizardException;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public final class UnzipOperation
extends PreinstallOperation<File> {
    private final InstallContext myContext;
    private final File myArchive;

    public UnzipOperation(InstallContext context, File archive, double progressShare) {
        super(context, progressShare);
        this.myContext = context;
        this.myArchive = archive;
    }

    private File unzip(ProgressIndicator progressIndicator, File archive, File tempDirectory) throws WizardException {
        this.myContext.print(String.format("Unpacking %s\n", archive.getName()), ConsoleViewContentType.SYSTEM_OUTPUT);
        File dir = new File(tempDirectory, archive.getName() + "-unpacked");
        while (true) {
            try {
                ZipUtil.unzip((ProgressIndicator)progressIndicator, (File)dir, (File)archive, null, null, (boolean)true);
                if (archive.getCanonicalPath().startsWith(this.myContext.getTempDirectory().getCanonicalPath())) {
                    FileUtil.delete((File)archive);
                }
                return dir;
            }
            catch (IOException e) {
                String failure = String.format("Unable to unzip file %1$s", archive.getName());
                String message = WelcomeUIUtils.getMessageWithDetails(failure, e.getMessage());
                this.promptToRetry(message + " Make sure you have enough disk space on destination drive and retry.", message, e);
                continue;
            }
            break;
        }
    }

    @Override
    @Nullable
    protected File perform() throws WizardException {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator.isCanceled()) {
            return null;
        }
        return this.unzip(progressIndicator, this.myArchive, this.myContext.getTempDirectory());
    }
}

