/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem {
    @Nullable
    public abstract VirtualFile getRootByLocal(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getRootByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getRootByEntry"));
        }
        if (entry.getFileSystem() != this) {
            return null;
        }
        String rootPath = this.extractRootPath(entry.getPath());
        return this.findFileByPath(rootPath);
    }

    @Nullable
    public VirtualFile getLocalByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getLocalByEntry"));
        }
        if (entry.getFileSystem() != this) {
            return null;
        }
        String localPath = this.extractLocalPath(this.extractRootPath(entry.getPath()));
        return LocalFileSystem.getInstance().findFileByPath(localPath);
    }

    @NotNull
    protected abstract String extractLocalPath(@NotNull String var1);

    @NotNull
    protected abstract String convertLocalToRootPath(@NotNull String var1);

    @NotNull
    protected abstract ArchiveHandler getHandler(@NotNull VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "copyFile"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "createChildDirectory"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "createChildFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "createChildFile"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "deleteFile"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "moveFile"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "renameFile"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @NotNull
    protected String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getRelativePath"));
        }
        String path = file.getPath();
        String relativePath = path.substring(this.extractRootPath(path).length());
        String string = StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') ? relativePath.substring(1) : relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getRelativePath"));
        }
        return string;
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getAttributes"));
        }
        return this.getHandler(file).getAttributes(this.getRelativePath(file));
    }

    @Override
    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "list"));
        }
        String[] stringArray = this.getHandler(file).list(this.getRelativePath(file));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "list"));
        }
        return stringArray;
    }

    @Override
    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "exists"));
        }
        if (file.getParent() == null) {
            return this.getLocalByEntry(file) != null;
        }
        return this.getAttributes(file) != null;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "isDirectory"));
        }
        if (file.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes == null || attributes.isDirectory();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "isWritable"));
        }
        return false;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getTimeStamp"));
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    @Override
    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getLength"));
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "contentsToByteArray"));
        }
        byte[] byArray = this.getHandler(file).contentsToByteArray(this.getRelativePath(file));
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "setTimeStamp"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "setWritable"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem", "getOutputStream"));
        }
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }
}

