/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.ListScrollingUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JList;

public class ListDelegationUtil {
    public static ActionCallback installKeyboardDelegation(final JComponent focusedComponent, final JList delegateTo) {
        final KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                int modifiers = e.getModifiers();
                switch (code) {
                    case 38: {
                        ListScrollingUtil.moveUp(delegateTo, modifiers);
                        break;
                    }
                    case 40: {
                        ListScrollingUtil.moveDown(delegateTo, modifiers);
                        break;
                    }
                    case 36: {
                        ListScrollingUtil.moveHome(delegateTo);
                        break;
                    }
                    case 35: {
                        ListScrollingUtil.moveEnd(delegateTo);
                        break;
                    }
                    case 33: {
                        ListScrollingUtil.movePageUp(delegateTo);
                        break;
                    }
                    case 34: {
                        ListScrollingUtil.movePageDown(delegateTo);
                    }
                }
            }
        };
        focusedComponent.addKeyListener(keyListener);
        ActionCallback callback = new ActionCallback();
        callback.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                focusedComponent.removeKeyListener(keyListener);
            }
        });
        return callback;
    }
}

