/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HintUpdateSupply {
    private static final Key<HintUpdateSupply> HINT_UPDATE_MARKER = Key.create((String)"HINT_UPDATE_MARKER");
    @Nullable
    private JBPopup myHint;

    @Nullable
    public static HintUpdateSupply getSupply(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/HintUpdateSupply", "getSupply"));
        }
        return (HintUpdateSupply)component.getClientProperty(HINT_UPDATE_MARKER);
    }

    public static void hideHint(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/HintUpdateSupply", "hideHint"));
        }
        HintUpdateSupply supply = HintUpdateSupply.getSupply(component);
        if (supply != null) {
            supply.hideHint();
        }
    }

    protected HintUpdateSupply(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/HintUpdateSupply", "<init>"));
        }
        this.installSupply(component);
    }

    public HintUpdateSupply(final @NotNull JBTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ui/popup/HintUpdateSupply", "<init>"));
        }
        this.installSupply(table);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(table)) {
                    return;
                }
                int selected = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
                int rowCount = table.getRowCount();
                if (selected == -1 || rowCount == 0) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(table.getValueAt(Math.min(selected, rowCount - 1), 0));
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(listener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    public HintUpdateSupply(final @NotNull Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/popup/HintUpdateSupply", "<init>"));
        }
        this.installSupply(tree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiElement psiElement;
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(tree)) {
                    return;
                }
                TreePath path = tree.getSelectionPath();
                if (path != null && (psiElement = HintUpdateSupply.this.getPsiElementForHint(path.getLastPathComponent())) != null && psiElement.isValid()) {
                    HintUpdateSupply.this.updateHint(psiElement);
                }
            }
        });
    }

    public HintUpdateSupply(final @NotNull JBList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/HintUpdateSupply", "<init>"));
        }
        this.installSupply(list);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(list)) {
                    return;
                }
                Object[] selectedValues = ((JList)e.getSource()).getSelectedValues();
                if (selectedValues.length != 1) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(selectedValues[0]);
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        });
    }

    @Nullable
    protected abstract PsiElement getPsiElementForHint(@Nullable Object var1);

    private void installSupply(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/HintUpdateSupply", "installSupply"));
        }
        component.putClientProperty(HINT_UPDATE_MARKER, this);
    }

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (HintUpdateSupply.isHintVisible(this.myHint)) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (!HintUpdateSupply.isHintVisible(this.myHint)) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    @Contract(value="!null->true")
    private static boolean isHintVisible(JBPopup hint) {
        return hint != null && hint.isVisible();
    }

    private static boolean isSelectedByMouse(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/popup/HintUpdateSupply", "isSelectedByMouse"));
        }
        return Boolean.TRUE.equals(c.getClientProperty("byMouseEvent"));
    }
}

