/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.StatusWalkerPartner;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRecursiveStatusWalker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnRecursiveStatusWalker");
    private final StatusWalkerPartner myPartner;
    private final SvnVcs myVcs;
    private final Project myProject;
    private final StatusReceiver myReceiver;
    private final LinkedList<MyItem> myQueue;
    private final MyHandler myHandler;

    public SvnRecursiveStatusWalker(SvnVcs vcs, StatusReceiver receiver, StatusWalkerPartner partner) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myReceiver = receiver;
        this.myPartner = partner;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void go(FilePath rootPath, Depth depth) throws SvnBindException {
        MyItem root = this.createItem(rootPath, depth, false);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            this.myPartner.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            FilePath path = item.getPath();
            File ioFile = path.getIOFile();
            if (path.isDirectory()) {
                this.myHandler.setCurrentItem(item);
                try {
                    StatusClient client = item.getClient();
                    client.doStatus(ioFile, SVNRevision.WORKING, item.getDepth(), false, false, true, true, this.myHandler, null);
                    this.myHandler.checkIfCopyRootWasReported(null, ioFile);
                }
                catch (SvnBindException e) {
                    this.handleStatusException(item, path, e);
                }
                continue;
            }
            try {
                Status status = item.getClient().doStatus(ioFile, false);
                this.myReceiver.process(path, status);
            }
            catch (SvnBindException e) {
                this.handleStatusException(item, path, e);
            }
            catch (SVNException e) {
                this.handleStatusException(item, path, new SvnBindException(e));
            }
        }
    }

    private void handleStatusException(MyItem item, FilePath path, SvnBindException e) throws SvnBindException {
        if (e.contains(SVNErrorCode.WC_NOT_DIRECTORY) || e.contains(SVNErrorCode.WC_NOT_FILE)) {
            VirtualFile virtualFile = path.getVirtualFile();
            if (virtualFile != null && !this.myPartner.isIgnoredByVcs(virtualFile)) {
                this.myReceiver.processUnversioned(virtualFile);
                if (virtualFile.isDirectory()) {
                    this.processRecursively(virtualFile, item.getDepth());
                }
            }
        } else {
            throw e;
        }
    }

    private void processRecursively(VirtualFile vFile, Depth prevDepth) {
        Object processor;
        Object directoryFilter;
        if (Depth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.myPartner.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        final Depth newDepth = Depth.INFINITY.equals((Object)prevDepth) ? Depth.INFINITY : Depth.EMPTY;
        final File ioFile = new File(vFile.getPath());
        final Ref lastIgnored = new Ref();
        Processor<File> checkDirProcessor = new Processor<File>(){

            public boolean process(File file) {
                FilePathImpl path = new FilePathImpl(file, true);
                path.refresh();
                path.hardRefresh();
                VirtualFile vf = path.getVirtualFile();
                if (vf != null && SvnRecursiveStatusWalker.this.myPartner.isIgnoredIdeaLevel(vf)) {
                    lastIgnored.set((Object)file);
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                    return true;
                }
                if (file.isDirectory() && new File(file, SVNFileUtil.getAdminDirectoryName()).exists()) {
                    MyItem childItem = SvnRecursiveStatusWalker.this.createItem((FilePath)path, newDepth, true);
                    SvnRecursiveStatusWalker.this.myQueue.add(childItem);
                } else if (vf != null) {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                }
                return true;
            }
        };
        if (Depth.EMPTY.equals((Object)newDepth)) {
            directoryFilter = new Processor<File>(){

                public boolean process(File file) {
                    return FileUtil.filesEqual((File)ioFile, (File)file);
                }
            };
            processor = new Processor<File>((Processor)checkDirProcessor){
                final /* synthetic */ Processor val$checkDirProcessor;
                {
                    this.val$checkDirProcessor = processor;
                }

                public boolean process(File file) {
                    return FileUtil.filesEqual((File)ioFile, (File)file) || this.val$checkDirProcessor.process((Object)file);
                }
            };
        } else {
            directoryFilter = new Processor<File>(){

                public boolean process(File file) {
                    return !Comparing.equal((Object)lastIgnored, (Object)file) && (SvnRecursiveStatusWalker.this.myQueue.isEmpty() || !FileUtil.filesEqual((File)((MyItem)SvnRecursiveStatusWalker.this.myQueue.getLast()).getPath().getIOFile(), (File)file));
                }
            };
            processor = checkDirProcessor;
        }
        FileUtil.processFilesRecursively((File)ioFile, (Processor)processor, (Processor)directoryFilter);
    }

    @NotNull
    private MyItem createItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        StatusClient statusClient = this.myVcs.getFactory(path.getIOFile()).createStatusClient(this.myPartner.getFileProvider(), this.myPartner.getEventHandler());
        MyItem myItem = new MyItem(path, depth, isInnerCopyRoot, statusClient);
        if (myItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker", "createItem"));
        }
        return myItem;
    }

    private static VirtualFile getVirtualFile(File ioFile) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vFile = lfs.findFileByIoFile(ioFile);
        if (vFile == null) {
            vFile = lfs.refreshAndFindFileByIoFile(ioFile);
        }
        return vFile;
    }

    private class MyHandler
    implements StatusConsumer {
        private MyItem myCurrentItem;
        private boolean myMetCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(MyItem currentItem) {
            this.myCurrentItem = currentItem;
            this.myMetCurrentItem = false;
        }

        public void checkIfCopyRootWasReported(@Nullable Status ioFileStatus, File ioFile) {
            File itemFile = this.myCurrentItem.getPath().getIOFile();
            if (!this.myMetCurrentItem && FileUtil.filesEqual((File)ioFile, (File)itemFile)) {
                Status statusInner;
                this.myMetCurrentItem = true;
                try {
                    statusInner = ioFileStatus != null ? ioFileStatus : this.myCurrentItem.getClient().doStatus(itemFile, false);
                }
                catch (SvnBindException e) {
                    LOG.info((Throwable)((Object)e));
                    statusInner = null;
                }
                if (statusInner == null) {
                    return;
                }
                StatusType status = statusInner.getNodeStatus();
                VirtualFile vf = this.myCurrentItem.getPath().getVirtualFile();
                if (StatusType.STATUS_IGNORED.equals((Object)status)) {
                    if (vf != null) {
                        SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                    }
                    return;
                }
                if (StatusType.STATUS_UNVERSIONED.equals((Object)status) || StatusType.UNKNOWN.equals((Object)status)) {
                    if (vf != null) {
                        SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                        SvnRecursiveStatusWalker.this.processRecursively(vf, this.myCurrentItem.getDepth());
                    }
                    return;
                }
                if (StatusType.OBSTRUCTED.equals((Object)status) || StatusType.STATUS_NONE.equals((Object)status)) {
                    return;
                }
                if (vf != null) {
                    if (this.myCurrentItem.isIsInnerCopyRoot()) {
                        SvnRecursiveStatusWalker.this.myReceiver.processCopyRoot(vf, statusInner.getURL(), SvnRecursiveStatusWalker.this.myVcs.getWorkingCopyFormat(ioFile), statusInner.getRepositoryRootURL());
                    } else {
                        SvnRecursiveStatusWalker.this.myReceiver.bewareRoot(vf, statusInner.getURL());
                    }
                }
            }
        }

        public void consume(Status status) throws SVNException {
            Boolean excluded;
            SvnRecursiveStatusWalker.this.myPartner.checkCanceled();
            File ioFile = status.getFile();
            this.checkIfCopyRootWasReported(status, ioFile);
            final VirtualFile vFile = SvnRecursiveStatusWalker.getVirtualFile(ioFile);
            if (vFile != null && Boolean.TRUE.equals(excluded = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                        return null;
                    }
                    return SvnRecursiveStatusWalker.this.myPartner.isIgnoredByVcs(vFile);
                }
            }))) {
                return;
            }
            if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null && status.is(StatusType.STATUS_UNVERSIONED)) {
                if (vFile.isDirectory()) {
                    if (!FileUtil.filesEqual((File)this.myCurrentItem.getPath().getIOFile(), (File)ioFile)) {
                        MyItem childItem = SvnRecursiveStatusWalker.this.createItem((FilePath)new FilePathImpl(vFile), Depth.INFINITY, true);
                        SvnRecursiveStatusWalker.this.myQueue.add(childItem);
                    }
                } else {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                }
            } else {
                FilePath path = VcsUtil.getFilePath((File)ioFile, (boolean)status.getKind().isDirectory());
                SvnRecursiveStatusWalker.this.myReceiver.process(path, status);
            }
        }
    }

    private static class MyItem {
        @NotNull
        private final FilePath myPath;
        @NotNull
        private final Depth myDepth;
        @NotNull
        private final StatusClient myStatusClient;
        private final boolean myIsInnerCopyRoot;

        private MyItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot, @NotNull StatusClient statusClient) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            if (depth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            if (statusClient == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusClient", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "<init>"));
            }
            this.myPath = path;
            this.myDepth = depth;
            this.myStatusClient = statusClient;
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getPath"));
            }
            return filePath;
        }

        @NotNull
        public Depth getDepth() {
            Depth depth = this.myDepth;
            if (depth == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getDepth"));
            }
            return depth;
        }

        @NotNull
        public StatusClient getClient() {
            StatusClient statusClient = this.myStatusClient;
            if (statusClient == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem", "getClient"));
            }
            return statusClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }
    }
}

