/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnTreeConflictResolver {
    private final SvnVcs myVcs;
    private final FilePath myPath;
    private VcsRevisionNumber myCommittedRevision;
    private final FilePath myRevertPath;
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public SvnTreeConflictResolver(SvnVcs vcs, FilePath path, VcsRevisionNumber committedRevision, @Nullable FilePath revertPath) {
        this.myVcs = vcs;
        this.myPath = path;
        this.myCommittedRevision = committedRevision;
        this.myRevertPath = revertPath;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveSelectTheirsFull(TreeConflictDescription d) throws VcsException {
        LocalHistory localHistory = LocalHistory.getInstance();
        localHistory.putSystemLabel(this.myVcs.getProject(), "Before accepting theirs for " + TreeConflictRefreshablePanel.filePath(this.myPath));
        try {
            this.updatetoTheirsFull();
            this.pathDirty(this.myPath);
            this.revertAdditional();
        }
        finally {
            localHistory.putSystemLabel(this.myVcs.getProject(), "After accepting theirs for " + TreeConflictRefreshablePanel.filePath(this.myPath));
        }
    }

    private void pathDirty(FilePath path) {
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (validParent == null) {
            return;
        }
        validParent.refresh(false, true);
        if (path.isDirectory()) {
            this.myDirtyScopeManager.dirDirtyRecursively(path);
        } else {
            this.myDirtyScopeManager.fileDirty(path);
        }
    }

    private void revertAdditional() throws VcsException {
        if (this.myRevertPath == null) {
            return;
        }
        File ioFile = this.myRevertPath.getIOFile();
        Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
        this.myVcs.getFactory(ioFile).createRevertClient().revert(new File[]{ioFile}, Depth.INFINITY, null);
        if (StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
            FileUtil.delete((File)ioFile);
        }
        this.pathDirty(this.myRevertPath);
    }

    public void resolveSelectMineFull(TreeConflictDescription d) throws VcsException {
        File ioFile = this.myPath.getIOFile();
        this.myVcs.getFactory(ioFile).createConflictClient().resolve(ioFile, Depth.INFINITY, true, true, true);
        this.pathDirty(this.myPath);
    }

    private void updatetoTheirsFull() throws VcsException {
        File ioFile = this.myPath.getIOFile();
        Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
        if (this.myCommittedRevision == null) {
            this.myCommittedRevision = new SvnRevisionNumber(status.getCommittedRevision());
        }
        if (status == null || StatusType.STATUS_UNVERSIONED.equals((Object)status.getNodeStatus())) {
            this.myVcs.getFactory(ioFile).createRevertClient().revert(new File[]{ioFile}, Depth.INFINITY, null);
            this.updateIoFile(ioFile, SVNRevision.HEAD);
            return;
        }
        if (StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
            this.myVcs.getFactory(ioFile).createRevertClient().revert(new File[]{ioFile}, Depth.INFINITY, null);
            this.updateIoFile(ioFile, SVNRevision.HEAD);
            FileUtil.delete((File)ioFile);
            return;
        }
        final HashSet usedToBeAdded = new HashSet();
        if (this.myPath.isDirectory()) {
            StatusClient statusClient = this.myVcs.getFactory(ioFile).createStatusClient();
            statusClient.doStatus(ioFile, SVNRevision.UNDEFINED, Depth.INFINITY, false, false, false, false, new StatusConsumer(){

                public void consume(Status status) throws SVNException {
                    if (status != null && StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
                        usedToBeAdded.add(status.getFile());
                    }
                }
            }, null);
        }
        this.myVcs.getFactory(ioFile).createRevertClient().revert(new File[]{ioFile}, Depth.INFINITY, null);
        for (File wasAdded : usedToBeAdded) {
            FileUtil.delete((File)wasAdded);
        }
        this.updateIoFile(ioFile, SVNRevision.HEAD);
    }

    private void updateIoFile(@NotNull File ioFile, @NotNull SVNRevision revision) throws SvnBindException {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "updateIoFile"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "updateIoFile"));
        }
        if (!ioFile.exists()) {
            File parent = ioFile.getParentFile();
            this.myVcs.getFactory(parent).createUpdateClient().doUpdate(parent, revision, Depth.INFINITY, true, false);
        } else {
            this.myVcs.getFactory(ioFile).createUpdateClient().doUpdate(ioFile, revision, Depth.INFINITY, false, false);
        }
    }
}

