/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.missing;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.GroovyCodeInsightBundle;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyGeneratePropertyMissingHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance(GroovyGeneratePropertyMissingHandler.class);

    public GroovyGeneratePropertyMissingHandler() {
        super("");
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        return ClassMember.EMPTY_ARRAY;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        String templName = "New Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate("New Method Body.java");
        GrMethod getter = GroovyGeneratePropertyMissingHandler.genGetter(aClass, template);
        GrMethod setter = GroovyGeneratePropertyMissingHandler.genSetter(aClass, template);
        ArrayList<GroovyGenerationInfo<GrMethod>> result = new ArrayList<GroovyGenerationInfo<GrMethod>>();
        if (getter != null) {
            result.add(new GroovyGenerationInfo<GrMethod>(getter, true));
        }
        if (setter != null) {
            result.add(new GroovyGenerationInfo<GrMethod>(setter, true));
        }
        ArrayList<GroovyGenerationInfo<GrMethod>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/actions/generate/missing/GroovyGeneratePropertyMissingHandler", "generateMemberPrototypes"));
        }
        return arrayList;
    }

    @Nullable
    private static GrMethod genGetter(PsiClass aClass, FileTemplate template) {
        String bodyText;
        Properties properties = FileTemplateManager.getInstance().getDefaultProperties(aClass.getProject());
        properties.setProperty("RETURN_TYPE", "java.lang.Object");
        properties.setProperty("DEFAULT_RETURN_VALUE", "null");
        properties.setProperty("CALL_SUPER", "");
        properties.setProperty("CLASS_NAME", aClass.getQualifiedName());
        properties.setProperty("SIMPLE_CLASS_NAME", aClass.getName());
        properties.setProperty("METHOD_NAME", "propertyMissing");
        try {
            bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
        }
        catch (IOException e) {
            return null;
        }
        return GroovyPsiElementFactory.getInstance(aClass.getProject()).createMethodFromText("def propertyMissing(String name) {\n" + bodyText + "\n}");
    }

    @Nullable
    private static GrMethod genSetter(PsiClass aClass, FileTemplate template) {
        String bodyText;
        Properties properties = FileTemplateManager.getInstance().getDefaultProperties(aClass.getProject());
        properties.setProperty("RETURN_TYPE", "void");
        properties.setProperty("DEFAULT_RETURN_VALUE", "");
        properties.setProperty("CALL_SUPER", "");
        properties.setProperty("CLASS_NAME", aClass.getQualifiedName());
        properties.setProperty("SIMPLE_CLASS_NAME", aClass.getName());
        properties.setProperty("METHOD_NAME", "propertyMissing");
        try {
            bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
        }
        catch (IOException e) {
            return null;
        }
        return GroovyPsiElementFactory.getInstance(aClass.getProject()).createMethodFromText("def propertyMissing(String name, def arg) {\n" + bodyText + "\n}");
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return GenerationInfo.EMPTY_ARRAY;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        PsiMethod[] missings = aClass.findMethodsByName("propertyMissing", true);
        PsiMethod getter = null;
        PsiMethod setter = null;
        for (PsiMethod missing : missings) {
            PsiParameter[] parameters = missing.getParameterList().getParameters();
            if (parameters.length == 1) {
                if (!GroovyGeneratePropertyMissingHandler.isNameParam(parameters[0])) continue;
                getter = missing;
                continue;
            }
            if (parameters.length != 2 || !GroovyGeneratePropertyMissingHandler.isNameParam(parameters[0])) continue;
            setter = missing;
        }
        if (setter != null && getter != null) {
            String text = GroovyCodeInsightBundle.message("generate.property.missing.already.defined.warning", new Object[0]);
            if (Messages.showYesNoDialog((Project)project, (String)text, (String)GroovyCodeInsightBundle.message("generate.property.missing.already.defined.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                final PsiMethod finalGetter = getter;
                final PsiMethod finalSetter = setter;
                if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        try {
                            finalSetter.delete();
                            finalGetter.delete();
                            return Boolean.TRUE;
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return Boolean.FALSE;
                        }
                    }
                })).booleanValue()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new ClassMember[1];
    }

    private static boolean isNameParam(PsiParameter parameter) {
        return parameter.getType().equalsToText("java.lang.String") || parameter.getType().equalsToText("java.lang.Object");
    }

    @Nullable
    protected ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project, @Nullable Editor editor) {
        return ClassMember.EMPTY_ARRAY;
    }
}

