/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.console.GroovyShellActionBase;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;

public class GroovyConsoleAction
extends GroovyShellActionBase {
    @Override
    protected GroovyShellRunner getRunner(Module module) {
        return GroovyShellRunner.getAppropriateRunner(module);
    }

    @Override
    public String getTitle() {
        return "Groovy Console";
    }

    @Override
    protected LanguageConsoleImpl createConsole(Project project, String title) {
        return new LanguageConsoleImpl(project, title, GroovyLanguage.INSTANCE){

            @NotNull
            protected PsiFile createFile(@NotNull LightVirtualFile virtualFile, @NotNull Document document, @NotNull Project project) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                GroovyCodeFragment groovyCodeFragment = new GroovyCodeFragment(this.getProject(), (VirtualFile)virtualFile);
                if (groovyCodeFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                return groovyCodeFragment;
            }
        };
    }
}

