/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.util.SdkHomeSettings;

public abstract class SdkHomeConfigurable
implements SearchableConfigurable {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myPathField;
    protected final Project myProject;
    protected final String myFrameworkName;

    public SdkHomeConfigurable(Project project, String frameworkName) {
        this.myProject = project;
        this.myFrameworkName = frameworkName;
    }

    @Nls
    public String getDisplayName() {
        return this.myFrameworkName;
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new BorderLayout(10, 5));
        JPanel contentPanel = new JPanel(new BorderLayout(4, 0));
        this.myPanel.add((Component)contentPanel, "North");
        contentPanel.add((Component)new JLabel(this.myFrameworkName + " home:"), "West");
        this.myPathField = new TextFieldWithBrowseButton();
        contentPanel.add((Component)this.myPathField);
        this.myPathField.addBrowseFolderListener("Select " + this.myFrameworkName + " home", "", this.myProject, new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return SdkHomeConfigurable.this.isSdkHome(file);
            }
        });
        return this.myPanel;
    }

    protected abstract boolean isSdkHome(VirtualFile var1);

    public boolean isModified() {
        return !this.myPathField.getText().equals(this.getStateText());
    }

    public void apply() throws ConfigurationException {
        SdkHomeBean state = new SdkHomeBean();
        state.SDK_HOME = FileUtil.toSystemIndependentName((String)this.myPathField.getText());
        this.getFrameworkSettings().loadState(state);
    }

    protected abstract SdkHomeSettings getFrameworkSettings();

    public void reset() {
        this.myPathField.setText(this.getStateText());
    }

    private String getStateText() {
        SdkHomeBean state = this.getFrameworkSettings().getState();
        String stateText = state == null ? "" : state.SDK_HOME;
        return FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)stateText));
    }

    public void disposeUIResources() {
        this.myPathField = null;
        this.myPanel = null;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/SdkHomeConfigurable", "getId"));
        }
        return string;
    }

    public static class SdkHomeBean {
        public String SDK_HOME;
    }
}

