/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.application.options.codeStyle.arrangement.action.AbstractArrangementRuleAction;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMoveArrangementRuleAction
extends AbstractArrangementRuleAction
implements DumbAware {
    public void update(AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ArrayList<int[]> mappings = new ArrayList<int[]>();
        this.fillMappings(control, mappings);
        for (int[] mapping : mappings) {
            if (mapping[0] == mapping[1]) continue;
            e.getPresentation().setEnabled(true);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(AnActionEvent e) {
        final ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            return;
        }
        final int editing = control.getEditingRow() - 1;
        control.runOperationIgnoreSelectionChange(new Runnable(){

            @Override
            public void run() {
                control.hideEditor();
                ArrayList<int[]> mappings = new ArrayList<int[]>();
                AbstractMoveArrangementRuleAction.this.fillMappings(control, mappings);
                if (mappings.isEmpty()) {
                    return;
                }
                int newRowToEdit = editing;
                ArrangementMatchingRulesModel model = control.getModel();
                for (int[] pair : mappings) {
                    int to;
                    int from = pair[0];
                    if (from == (to = pair[1])) continue;
                    Object value = model.getElementAt(from);
                    model.removeRow(from);
                    model.insert(to, value);
                    if (newRowToEdit != from) continue;
                    newRowToEdit = to;
                }
                ListSelectionModel selectionModel = control.getSelectionModel();
                for (int[] pair : mappings) {
                    selectionModel.addSelectionInterval(pair[1], pair[1]);
                }
                int visibleRow = -1;
                if (newRowToEdit >= 0) {
                    control.showEditor(newRowToEdit);
                    visibleRow = newRowToEdit;
                } else if (!mappings.isEmpty()) {
                    visibleRow = ((int[])mappings.get(0))[1];
                }
                if (visibleRow != -1) {
                    AbstractMoveArrangementRuleAction.this.scrollRowToVisible(control, visibleRow);
                }
            }
        });
        control.repaintRows(0, control.getModel().getSize() - 1, true);
    }

    protected abstract void fillMappings(@NotNull ArrangementMatchingRulesControl var1, @NotNull List<int[]> var2);
}

