/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationPreviewPanelProvider
extends PreviewPanelProvider<Couple<PsiElement>, DocumentationComponent> {
    public static final PreviewProviderId<Couple<PsiElement>, DocumentationComponent> ID = PreviewProviderId.create("Documentation");
    private final DocumentationComponent myDocumentationComponent;
    private final DocumentationManager myDocumentationManager;
    private boolean myBlocked = false;

    public DocumentationPreviewPanelProvider(DocumentationManager documentationManager) {
        super(ID);
        this.myDocumentationManager = documentationManager;
        this.myDocumentationComponent = new DocumentationComponent(documentationManager){

            @Override
            public String toString() {
                return "Preview DocumentationComponent (" + (this.isEmpty() ? "empty" : "not empty") + ")";
            }
        };
    }

    @Override
    public boolean shouldBeEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        DocumentationComponent documentationComponent = this.myDocumentationComponent;
        if (documentationComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getComponent"));
        }
        return documentationComponent;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getTitle"));
        }
        String string = DocumentationManager.getTitle((PsiElement)content.getFirst(), false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getIcon"));
        }
        return ((PsiElement)content.getFirst()).getIcon(0);
    }

    @Override
    public float getMenuOrder() {
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveContentToStandardView(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "moveContentToStandardView"));
        }
        this.myBlocked = true;
        try {
            this.myDocumentationManager.showJavaDocInfo((PsiElement)content.getFirst(), (PsiElement)content.getSecond());
        }
        finally {
            this.myBlocked = false;
        }
        return true;
    }

    @Override
    protected DocumentationComponent initComponent(Couple<PsiElement> content, boolean requestFocus) {
        if (this.myBlocked) {
            return null;
        }
        if (!((PsiElement)content.getFirst()).getManager().areElementsEquivalent(this.myDocumentationComponent.getElement(), (PsiElement)content.getFirst())) {
            this.myDocumentationManager.fetchDocInfo((PsiElement)content.getFirst(), this.myDocumentationComponent);
        }
        return this.myDocumentationComponent;
    }
}

