/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.actions.GenerateActionPopupTemplateInjector;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateAction
extends DumbAwareAction
implements PreloadableAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message((String)"generate.list.popup.title", (Object[])new Object[0]), (ActionGroup)GenerateAction.wrapGroup(GenerateAction.getGroup(), dataContext), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        popup.showInBestPositionFor(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        boolean groupEmpty = ActionGroupUtil.isGroupEmpty((ActionGroup)GenerateAction.getGroup(), (AnActionEvent)event);
        presentation.setEnabled(!groupEmpty);
    }

    private static DefaultActionGroup getGroup() {
        return (DefaultActionGroup)ActionManager.getInstance().getAction("GenerateGroup");
    }

    private static DefaultActionGroup wrapGroup(DefaultActionGroup actionGroup, DataContext dataContext) {
        DefaultActionGroup copy = new DefaultActionGroup();
        for (AnAction action : actionGroup.getChildren(null)) {
            AnAction editTemplateAction;
            if (action instanceof GenerateActionPopupTemplateInjector && (editTemplateAction = ((GenerateActionPopupTemplateInjector)action).createEditTemplateAction(dataContext)) != null) {
                copy.add((AnAction)new GenerateWrappingGroup(action, editTemplateAction));
                continue;
            }
            if (action instanceof DefaultActionGroup) {
                copy.add((AnAction)GenerateAction.wrapGroup((DefaultActionGroup)action, dataContext));
                continue;
            }
            copy.add(action);
        }
        return copy;
    }

    public void preload() {
        ((ActionManagerImpl)ActionManager.getInstance()).preloadActionGroup("GenerateGroup");
    }

    private static class GenerateWrappingGroup
    extends ActionGroup {
        private final AnAction myAction;
        private final AnAction myEditTemplateAction;

        public GenerateWrappingGroup(AnAction action, AnAction editTemplateAction) {
            this.myAction = action;
            this.myEditTemplateAction = editTemplateAction;
            this.copyFrom(action);
            this.setPopup(true);
        }

        public boolean canBePerformed(DataContext context) {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{this.myEditTemplateAction};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/GenerateAction$GenerateWrappingGroup", "getChildren"));
            }
            return anActionArray;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myAction.actionPerformed(e);
        }
    }
}

