/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Producer;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewUtil {
    private EmmetPreviewUtil() {
    }

    @Nullable
    public static String calculateTemplateText(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "calculateTemplateText"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "calculateTemplateText"));
        }
        if (file instanceof XmlFile) {
            String templatePrefix;
            Ref generatedTemplate = new Ref();
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            CustomTemplateCallback callback = EmmetPreviewUtil.createCallback(editor, file, (Ref<TemplateImpl>)generatedTemplate);
            PsiElement context = callback.getContext();
            ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(context, false);
            if (generator != null && generator instanceof XmlZenCodingGenerator && (templatePrefix = new ZenCodingTemplate().computeTemplateKeyWithoutContextChecking(callback)) != null) {
                try {
                    String templateText;
                    ZenCodingTemplate.expand(templatePrefix, callback, generator, Collections.emptyList(), expandPrimitiveAbbreviations, 0);
                    TemplateImpl template = (TemplateImpl)generatedTemplate.get();
                    String string = templateText = template != null ? template.getTemplateText() : null;
                    if (!StringUtil.isEmpty((String)templateText)) {
                        return template.isToReformat() ? EmmetPreviewUtil.reformatTemplateText(file, templateText) : templateText;
                    }
                }
                catch (EmmetException e) {
                    return e.getMessage();
                }
            }
        }
        return null;
    }

    public static void addEmmetPreviewListeners(final @NotNull Editor editor, final @NotNull PsiFile file, final boolean expandPrimitiveAbbreviations) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "addEmmetPreviewListeners"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "addEmmetPreviewListeners"));
        }
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$1", "documentChanged"));
                }
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(editor);
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getDocument().removeDocumentListener((DocumentListener)this);
                }
            }
        });
        editor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$2", "caretPositionChanged"));
                }
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(e.getEditor());
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getEditor().getCaretModel().removeCaretListener((CaretListener)this);
                }
            }
        });
    }

    private static String reformatTemplateText(final @NotNull PsiFile file, @NotNull String templateText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "reformatTemplateText"));
        }
        if (templateText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateText", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "reformatTemplateText"));
        }
        final PsiFile copy = PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText(file.getName(), file.getFileType(), (CharSequence)templateText);
        VirtualFile vFile = copy.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)copy);
                    }
                });
            }
        });
        return copy.getText();
    }

    @NotNull
    private static CustomTemplateCallback createCallback(@NotNull Editor editor, @NotNull PsiFile file, final @NotNull Ref<TemplateImpl> generatedTemplate) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "createCallback"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "createCallback"));
        }
        if (generatedTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedTemplate", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "createCallback"));
        }
        CustomTemplateCallback customTemplateCallback = new CustomTemplateCallback(editor, file){

            @Override
            public void startTemplate(@NotNull Template template, Map<String, String> predefinedValues, TemplateEditingListener listener) {
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$4", "startTemplate"));
                }
                if (template instanceof TemplateImpl && !((TemplateImpl)template).isDeactivated()) {
                    generatedTemplate.set((Object)((TemplateImpl)template));
                }
            }

            @Override
            public void deleteTemplateKey(@NotNull String key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$4", "deleteTemplateKey"));
                }
            }
        };
        if (customTemplateCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil", "createCallback"));
        }
        return customTemplateCallback;
    }

    private static class TemplateTextProducer
    implements Producer<String> {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final PsiFile myFile;
        private final boolean myExpandPrimitiveAbbreviations;

        public TemplateTextProducer(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$TemplateTextProducer", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$TemplateTextProducer", "<init>"));
            }
            this.myEditor = editor;
            this.myFile = file;
            this.myExpandPrimitiveAbbreviations = expandPrimitiveAbbreviations;
        }

        @Nullable
        public String produce() {
            return EmmetPreviewUtil.calculateTemplateText(this.myEditor, this.myFile, this.myExpandPrimitiveAbbreviations);
        }
    }
}

