/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TryStatementPostfixTemplate
extends PostfixTemplate {
    protected TryStatementPostfixTemplate() {
        super("try", "try { exp } catch(Exception e)");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/TryStatementPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/TryStatementPostfixTemplate", "isApplicable"));
        }
        return null != PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiStatement.class});
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/TryStatementPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/TryStatementPostfixTemplate", "expand"));
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiStatement.class});
        assert (statement != null);
        PsiFile file = statement.getContainingFile();
        JavaWithTryCatchSurrounder surrounder = new JavaWithTryCatchSurrounder();
        Project project = context.getProject();
        TextRange range = surrounder.surroundElements(project, editor, new PsiElement[]{statement});
        if (range == null) {
            PostfixTemplatesUtils.showErrorHint(project, editor);
            return;
        }
        PsiElement element = file.findElementAt(range.getStartOffset());
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        assert (tryStatement != null);
        PsiCodeBlock block = tryStatement.getTryBlock();
        assert (block != null);
        PsiStatement statementInTry = (PsiStatement)ArrayUtil.getFirstElement((Object[])block.getStatements());
        if (null != statementInTry) {
            editor.getCaretModel().moveToOffset(statementInTry.getTextRange().getEndOffset());
        }
    }
}

