/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixWrapper
extends QuickFixAction {
    private final QuickFix myFix;
    private String myText;

    public LocalQuickFixWrapper(@NotNull QuickFix fix, @NotNull InspectionToolWrapper toolWrapper) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "<init>"));
        }
        super(fix.getName(), toolWrapper);
        this.myFix = fix;
        this.myText = this.myFix.getName();
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.getTemplatePresentation().setText(this.myText);
        e.getPresentation().setText(this.myText);
    }

    @Override
    public String getText(RefEntity where) {
        return this.myText;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "setText"));
        }
        this.myText = text;
    }

    @Override
    protected boolean isProblemDescriptorsAcceptable() {
        return true;
    }

    @NotNull
    public QuickFix getFix() {
        QuickFix quickFix = this.myFix;
        if (quickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "getFix"));
        }
        return quickFix;
    }

    @Nullable
    protected QuickFix getWorkingQuickFix(@NotNull QuickFix[] fixes) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "getWorkingQuickFix"));
        }
        for (QuickFix fix : fixes) {
            if (!this.myFix.getClass().isInstance(fix) || this.myFix instanceof IntentionWrapper && fix instanceof IntentionWrapper && !((IntentionWrapper)this.myFix).getAction().getClass().isInstance(((IntentionWrapper)fix).getAction())) continue;
            return fix;
        }
        return null;
    }

    @Override
    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        return true;
    }

    @Override
    protected void applyFix(final @NotNull Project project, final @NotNull GlobalInspectionContextImpl context, final @NotNull CommonProblemDescriptor[] descriptors, final @NotNull Set<PsiElement> ignoredElements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "applyFix"));
        }
        PsiModificationTracker tracker = PsiManager.getInstance((Project)project).getModificationTracker();
        if (this.myFix instanceof BatchQuickFix) {
            final ArrayList collectedElementsToIgnore = new ArrayList();
            Runnable refreshViews = new Runnable(){

                @Override
                public void run() {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        LocalQuickFixWrapper.this.ignore(ignoredElements, descriptor, LocalQuickFixWrapper.this.getWorkingQuickFix(descriptor.getFixes()), context);
                    }
                    RefManager refManager = context.getRefManager();
                    RefElement[] refElements = new RefElement[collectedElementsToIgnore.size()];
                    int collectedElementsToIgnoreSize = collectedElementsToIgnore.size();
                    for (int i = 0; i < collectedElementsToIgnoreSize; ++i) {
                        refElements[i] = refManager.getReference((PsiElement)collectedElementsToIgnore.get(i));
                    }
                    QuickFixAction.removeElements((RefEntity[])refElements, project, LocalQuickFixWrapper.this.myToolWrapper);
                }
            };
            ((BatchQuickFix)this.myFix).applyFix(project, descriptors, collectedElementsToIgnore, refreshViews);
            return;
        }
        boolean restart = false;
        for (CommonProblemDescriptor descriptor : descriptors) {
            QuickFix fix;
            QuickFix[] fixes;
            if (descriptor == null || (fixes = descriptor.getFixes()) == null || (fix = this.getWorkingQuickFix(fixes)) == null) continue;
            long startCount = tracker.getModificationCount();
            fix.applyFix(project, descriptor);
            if (startCount == tracker.getModificationCount()) continue;
            restart = true;
            this.ignore(ignoredElements, descriptor, fix, context);
        }
        if (restart) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    private void ignore(@NotNull Set<PsiElement> ignoredElements, @NotNull CommonProblemDescriptor descriptor, @Nullable QuickFix fix, @NotNull GlobalInspectionContextImpl context) {
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalQuickFixWrapper", "ignore"));
        }
        if (fix != null) {
            InspectionToolPresentation presentation = context.getPresentation(this.myToolWrapper);
            presentation.ignoreProblem(descriptor, fix);
        }
        if (descriptor instanceof ProblemDescriptor) {
            ignoredElements.add(((ProblemDescriptor)descriptor).getPsiElement());
        }
    }
}

