/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Chunk;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CompileDriver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileDriver");
    private final Project myProject;
    private final Map<Module, String> myModuleOutputPaths = new HashMap();
    private final Map<Module, String> myModuleTestOutputPaths = new HashMap();
    private static final Key<Boolean> COMPILATION_STARTED_AUTOMATICALLY = Key.create((String)"compilation_started_automatically");
    private CompilerFilter myCompilerFilter = CompilerFilter.ALL;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final Key<ExitStatus> COMPILE_SERVER_BUILD_STATUS = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");

    public CompileDriver(Project project) {
        this.myProject = project;
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
        this.myCompilerFilter = compilerFilter == null ? CompilerFilter.ALL : compilerFilter;
    }

    public void rebuild(CompileStatusNotification callback) {
        this.doRebuild(callback, null, new ProjectCompileScope(this.myProject));
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        if (this.validateCompilerConfiguration(scope)) {
            this.startup(scope, false, false, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public boolean isUpToDate(CompileScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation started");
        }
        CompilerTask task = new CompilerTask(this.myProject, "Classes up-to-date check", true, false, false, CompileDriver.isCompilationStartedAutomatically(scope));
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, task, scope, true, false);
        final Ref result = new Ref();
        task.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                if (indicator.isCanceled() || CompileDriver.this.myProject.isDisposed()) {
                    return;
                }
                try {
                    TaskFuture future = CompileDriver.this.compileInExternalProcess(compileContext, true);
                    if (future != null) {
                        while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                            if (!indicator.isCanceled()) continue;
                            future.cancel(false);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    result.set(COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext));
                    if (!CompileDriver.this.myProject.isDisposed()) {
                        CompilerCacheManager.getInstance(CompileDriver.this.myProject).flushCaches();
                    }
                }
            }
        }, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(result.get());
    }

    public void compile(CompileScope scope, CompileStatusNotification callback) {
        if (this.validateCompilerConfiguration(scope)) {
            this.startup(scope, false, true, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    private void doRebuild(CompileStatusNotification callback, CompilerMessage message, CompileScope compileScope) {
        if (this.validateCompilerConfiguration(compileScope)) {
            this.startup(compileScope, true, false, callback, message);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public static void setCompilationStartedAutomatically(CompileScope scope) {
        scope.putUserData(COMPILATION_STARTED_AUTOMATICALLY, (Object)Boolean.TRUE);
    }

    private static boolean isCompilationStartedAutomatically(CompileScope scope) {
        return Boolean.TRUE.equals(scope.getUserData(COMPILATION_STARTED_AUTOMATICALLY));
    }

    @Nullable
    private TaskFuture compileInExternalProcess(final @NotNull CompileContextImpl compileContext, boolean onlyCheckUpToDate) throws Exception {
        HashMap builderParams;
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/compiler/impl/CompileDriver", "compileInExternalProcess"));
        }
        CompileScope scope = compileContext.getCompileScope();
        List<String> paths = CompileScopeUtil.fetchFiles(compileContext);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean forceBuild = !compileContext.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> explicitScopes = CompileScopeUtil.getBaseScopeForExternalBuild(scope);
        if (explicitScopes != null) {
            scopes.addAll(explicitScopes);
        } else if (!compileContext.isRebuild() && !CompileScopeUtil.allProjectModulesAffected(compileContext)) {
            CompileScopeUtil.addScopesForModules(Arrays.asList(scope.getAffectedModules()), scopes, forceBuild);
        } else {
            scopes.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)forceBuild));
        }
        if (paths.isEmpty()) {
            for (BuildTargetScopeProvider provider : (BuildTargetScopeProvider[])BuildTargetScopeProvider.EP_NAME.getExtensions()) {
                scopes = CompileScopeUtil.mergeScopes(scopes, provider.getBuildTargetScopes(scope, this.myCompilerFilter, this.myProject, forceBuild));
            }
        }
        if (onlyCheckUpToDate) {
            builderParams = Collections.emptyMap();
        } else {
            Map exported = scope.exportUserData();
            if (!exported.isEmpty()) {
                builderParams = new HashMap();
                for (Map.Entry entry : exported.entrySet()) {
                    String _key = ((Key)entry.getKey()).toString();
                    String _value = entry.getValue().toString();
                    builderParams.put(_key, _value);
                }
            } else {
                builderParams = Collections.emptyMap();
            }
        }
        final MessageBus messageBus = this.myProject.getMessageBus();
        final MultiMap<String, Artifact> outputToArtifact = ArtifactCompilerUtil.containsArtifacts(scopes) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.myProject) : null;
        BuildManager buildManager = BuildManager.getInstance();
        buildManager.cancelAutoMakeTasks(this.myProject);
        return buildManager.scheduleBuild(this.myProject, compileContext.isRebuild(), compileContext.isMake(), onlyCheckUpToDate, scopes, paths, (Map<String, String>)builderParams, new DefaultMessageHandler(this.myProject){

            @Override
            public void buildStarted(UUID sessionId) {
            }

            @Override
            public void sessionTerminated(UUID sessionId) {
                if (compileContext.shouldUpdateProblemsView()) {
                    ProblemsView view = ProblemsView.SERVICE.getInstance(CompileDriver.this.myProject);
                    view.clearProgress();
                    view.clearOldMessages(compileContext.getCompileScope(), compileContext.getSessionId());
                }
            }

            @Override
            public void handleFailure(UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                String trace;
                compileContext.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string = trace = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (trace != null) {
                    LOG.info(trace);
                }
                compileContext.putUserData(COMPILE_SERVER_BUILD_STATUS, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
                String messageText = message.getText();
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator indicator = compileContext.getProgressIndicator();
                    indicator.setText(messageText);
                    if (message.hasDone()) {
                        indicator.setFraction((double)message.getDone());
                    }
                } else {
                    String sourceFilePath;
                    CompilerMessageCategory category = kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR ? CompilerMessageCategory.ERROR : (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.WARNING ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
                    String string = sourceFilePath = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                    if (sourceFilePath != null) {
                        sourceFilePath = FileUtil.toSystemIndependentName((String)sourceFilePath);
                    }
                    long line = message.hasLine() ? message.getLine() : -1L;
                    long column = message.hasColumn() ? message.getColumn() : -1L;
                    String srcUrl = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)sourceFilePath) : null;
                    compileContext.addMessage(category, messageText, srcUrl, (int)line, (int)column);
                }
            }

            @Override
            protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type eventType = event.getEventType();
                switch (eventType) {
                    case FILES_GENERATED: {
                        List generated = event.getGeneratedFilesList();
                        CompilationStatusListener publisher = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
                        THashSet writtenArtifactOutputPaths = outputToArtifact != null ? new THashSet(FileUtil.PATH_HASHING_STRATEGY) : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : generated) {
                            Collection artifacts;
                            String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            publisher.fileGenerated(root, relativePath);
                            if (outputToArtifact == null || (artifacts = outputToArtifact.get((Object)root)).isEmpty()) continue;
                            for (Artifact artifact : artifacts) {
                                ArtifactsCompiler.addChangedArtifact(compileContext, artifact);
                            }
                            writtenArtifactOutputPaths.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)root, (String)relativePath)));
                        }
                        if (writtenArtifactOutputPaths == null || writtenArtifactOutputPaths.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContext, (Set<String>)writtenArtifactOutputPaths);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus status = ExitStatus.SUCCESS;
                        if (event.hasCompletionStatus()) {
                            CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status completionStatus = event.getCompletionStatus();
                            switch (completionStatus) {
                                case CANCELED: {
                                    status = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    status = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    status = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    status = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, status);
                    }
                }
            }
        });
    }

    private void startup(final CompileScope scope, final boolean isRebuild, final boolean forceCompile, final CompileStatusNotification callback, final CompilerMessage message) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String contentName = forceCompile ? CompilerBundle.message((String)"compiler.content.name.compile", (Object[])new Object[0]) : CompilerBundle.message((String)"compiler.content.name.make", (Object[])new Object[0]);
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        CompilerTask compileTask = new CompilerTask(this.myProject, contentName, isUnitTestMode, true, true, CompileDriver.isCompilationStartedAutomatically(scope));
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Compiler");
        this.myProject.save();
        if (!isUnitTestMode) {
            ApplicationManager.getApplication().saveSettings();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, compileTask, scope, !isRebuild && !forceCompile, isRebuild);
        Runnable compileWork = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                if (indicator.isCanceled() || CompileDriver.this.myProject.isDisposed()) {
                    if (callback != null) {
                        callback.finished(true, 0, 0, (CompileContext)compileContext);
                    }
                    return;
                }
                try {
                    LOG.info("COMPILATION STARTED (BUILD PROCESS)");
                    if (message != null) {
                        compileContext.addMessage(message);
                    }
                    if (isRebuild) {
                        CompilerUtil.runInContext(compileContext, "Clearing build system data...", new ThrowableRunnable<Throwable>(){

                            public void run() throws Throwable {
                                CompilerCacheManager.getInstance(CompileDriver.this.myProject).clearCaches(compileContext);
                            }
                        });
                    }
                    boolean beforeTasksOk = CompileDriver.this.executeCompileTasks(compileContext, true);
                    int errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                    if (!beforeTasksOk || errorCount > 0) {
                        COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)(errorCount > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                        return;
                    }
                    TaskFuture future = CompileDriver.this.compileInExternalProcess(compileContext, false);
                    if (future != null) {
                        while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                            if (!indicator.isCanceled()) continue;
                            future.cancel(false);
                        }
                        if (!CompileDriver.this.executeCompileTasks(compileContext, false)) {
                            COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.CANCELLED);
                        }
                        if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                            COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.ERRORS);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    CompilerCacheManager.getInstance(CompileDriver.this.myProject).flushCaches();
                    long duration = CompileDriver.this.notifyCompilationCompleted(compileContext, callback, (ExitStatus)COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext));
                    CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
                }
            }
        };
        compileTask.start(compileWork, new Runnable(){

            @Override
            public void run() {
                int rv;
                if (isRebuild && (rv = Messages.showOkCancelDialog((Project)CompileDriver.this.myProject, (String)"You are about to rebuild the whole project.\nRun 'Make Project' instead?", (String)"Confirm Project Rebuild", (String)"Make", (String)"Rebuild", (Icon)Messages.getQuestionIcon())) == 0) {
                    CompileDriver.this.startup(scope, false, false, callback, null);
                    return;
                }
                CompileDriver.this.startup(scope, isRebuild, forceCompile, callback, message);
            }
        });
    }

    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext context) {
        return (ExitStatus)context.getUserData(COMPILE_SERVER_BUILD_STATUS);
    }

    private long notifyCompilationCompleted(final CompileContextImpl compileContext, final CompileStatusNotification callback, final ExitStatus _status) {
        final long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
        if (!this.myProject.isDisposed()) {
            Module[] affectedModules = compileContext.getCompileScope().getAffectedModules();
            if (_status != ExitStatus.UP_TO_DATE && _status != ExitStatus.CANCELLED) {
                HashSet<File> outputs = new HashSet<File>();
                for (String path : CompilerPathsEx.getOutputPaths((Module[])affectedModules)) {
                    outputs.add(new File(path));
                }
                if (!outputs.isEmpty()) {
                    ProgressIndicator indicator = compileContext.getProgressIndicator();
                    indicator.setText("Synchronizing output directories...");
                    CompilerUtil.refreshOutputDirectories(outputs, _status == ExitStatus.CANCELLED);
                    indicator.setText("");
                }
            }
            if (compileContext.isAnnotationProcessorsEnabled() && !this.myProject.isDisposed()) {
                THashSet genSourceRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
                for (Module module : affectedModules) {
                    String path;
                    if (!config.getAnnotationProcessingConfiguration(module).isEnabled() || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
                    genSourceRoots.add(new File(path));
                }
                if (!genSourceRoots.isEmpty()) {
                    LocalFileSystem.getInstance().refreshIoFiles((Iterable)genSourceRoots, true, true, null);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int errorCount = 0;
                int warningCount = 0;
                try {
                    errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                    warningCount = compileContext.getMessageCount(CompilerMessageCategory.WARNING);
                    if (callback != null) {
                        callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                    }
                }
                catch (Throwable throwable) {
                    if (callback != null) {
                        callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                    }
                    throw throwable;
                }
                if (!CompileDriver.this.myProject.isDisposed()) {
                    MessageType messageType;
                    String statusMessage = CompileDriver.createStatusMessage(_status, warningCount, errorCount, duration);
                    MessageType messageType2 = errorCount > 0 ? MessageType.ERROR : (messageType = warningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                    if (duration > 60000L && CompilerWorkspaceConfiguration.getInstance((Project)((CompileDriver)CompileDriver.this).myProject).DISPLAY_NOTIFICATION_POPUP) {
                        ToolWindowManager.getInstance((Project)CompileDriver.this.myProject).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, statusMessage);
                    }
                    String wrappedMessage = _status != ExitStatus.UP_TO_DATE ? "<a href='#'>" + statusMessage + "</a>" : statusMessage;
                    final Notification notification = CompilerManager.NOTIFICATION_GROUP.createNotification("", wrappedMessage, messageType.toNotificationType(), (NotificationListener)new MessagesActivationListener(compileContext)).setImportant(false);
                    compileContext.getBuildSession().registerCloseAction(new Runnable(){

                        @Override
                        public void run() {
                            notification.expire();
                        }
                    });
                    notification.notify(CompileDriver.this.myProject);
                    if (_status != ExitStatus.UP_TO_DATE && compileContext.getMessageCount(null) > 0) {
                        String msg = DateFormatUtil.formatDateTime((Date)new Date()) + " - " + statusMessage;
                        compileContext.addMessage(CompilerMessageCategory.INFORMATION, msg, null, -1, -1);
                    }
                }
            }
        });
        return duration;
    }

    private static String createStatusMessage(ExitStatus status, int warningCount, int errorCount, long duration) {
        String message;
        if (status == ExitStatus.CANCELLED) {
            message = CompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (status == ExitStatus.UP_TO_DATE) {
            message = CompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            message = status == ExitStatus.SUCCESS ? (warningCount > 0 ? CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{warningCount}) : CompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) : CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{errorCount, warningCount});
            message = message + " in " + StringUtil.formatDuration((long)duration);
        }
        return message;
    }

    private String getModuleOutputPath(Module module, boolean inTestSourceContent) {
        Map<Module, String> map = inTestSourceContent ? this.myModuleTestOutputPaths : this.myModuleOutputPaths;
        String path = map.get(module);
        if (path == null) {
            path = CompilerPaths.getModuleOutputPath((Module)module, (boolean)inTestSourceContent);
            map.put(module, path);
        }
        return path;
    }

    public void executeCompileTask(final CompileTask task, CompileScope scope, String contentName, final Runnable onTaskFinished) {
        CompilerTask progressManagerTask = new CompilerTask(this.myProject, contentName, false, false, true, CompileDriver.isCompilationStartedAutomatically(scope));
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, progressManagerTask, scope, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        progressManagerTask.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.execute((CompileContext)compileContext);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    if (onTaskFinished != null) {
                        onTaskFinished.run();
                    }
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCompileTasks(CompileContext context, boolean beforeTasks) {
        ProgressIndicator progressIndicator;
        block8: {
            boolean bl;
            if (this.myProject.isDisposed()) {
                return false;
            }
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            progressIndicator = context.getProgressIndicator();
            progressIndicator.pushState();
            try {
                CompileTask[] tasks;
                CompileTask[] compileTaskArray = tasks = beforeTasks ? manager.getBeforeTasks() : manager.getAfterTasks();
                if (tasks.length <= 0) break block8;
                progressIndicator.setText(beforeTasks ? CompilerBundle.message((String)"progress.executing.precompile.tasks", (Object[])new Object[0]) : CompilerBundle.message((String)"progress.executing.postcompile.tasks", (Object[])new Object[0]));
                for (CompileTask task : tasks) {
                    if (task.execute(context)) break block9;
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                progressIndicator.popState();
                WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                if (progressIndicator instanceof CompilerTask) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(progressIndicator){
                        final /* synthetic */ ProgressIndicator val$progressIndicator;
                        {
                            this.val$progressIndicator = progressIndicator;
                        }

                        @Override
                        public void run() {
                            ((CompilerTask)this.val$progressIndicator).showCompilerContent();
                        }
                    });
                }
                throw throwable;
            }
            {
                block9: {
                    progressIndicator.popState();
                    WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                    if (progressIndicator instanceof CompilerTask) {
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    return bl;
                }
                continue;
            }
        }
        progressIndicator.popState();
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
        if (progressIndicator instanceof CompilerTask) {
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return true;
    }

    private boolean validateCompilerConfiguration(CompileScope scope) {
        try {
            Module[] scopeModules = scope.getAffectedModules();
            ArrayList<String> modulesWithoutOutputPathSpecified = new ArrayList<String>();
            ArrayList<String> modulesWithoutJdkAssigned = new ArrayList<String>();
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            for (Module module : scopeModules) {
                if (!compilerManager.isValidationEnabled(module)) continue;
                boolean hasSources = CompileDriver.hasSources(module, JavaSourceRootType.SOURCE);
                boolean hasTestSources = CompileDriver.hasSources(module, JavaSourceRootType.TEST_SOURCE);
                if (!hasSources && !hasTestSources) continue;
                Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    modulesWithoutJdkAssigned.add(module.getName());
                }
                String outputPath = this.getModuleOutputPath(module, false);
                String testsOutputPath = this.getModuleOutputPath(module, true);
                if (outputPath == null && testsOutputPath == null) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                    continue;
                }
                if (outputPath == null && hasSources) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                }
                if (testsOutputPath != null || !hasTestSources) continue;
                modulesWithoutOutputPathSpecified.add(module.getName());
            }
            if (!modulesWithoutJdkAssigned.isEmpty()) {
                this.showNotSpecifiedError("error.jdk.not.specified", modulesWithoutJdkAssigned, ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
                return false;
            }
            if (!modulesWithoutOutputPathSpecified.isEmpty()) {
                this.showNotSpecifiedError("error.output.not.specified", modulesWithoutOutputPathSpecified, CommonContentEntriesEditor.NAME);
                return false;
            }
            List chunks = ModuleCompilerUtil.getCyclicDependencies((Project)this.myProject, Arrays.asList(scopeModules));
            for (Chunk chunk : chunks) {
                Set sourceSets = chunk.getNodes();
                if (sourceSets.size() <= 1) continue;
                Sdk jdk = null;
                LanguageLevel languageLevel = null;
                for (ModuleSourceSet sourceSet : sourceSets) {
                    Module module = sourceSet.getModule();
                    Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (jdk == null) {
                        jdk = moduleJdk;
                    } else if (!jdk.equals(moduleJdk)) {
                        this.showCyclicModulesHaveDifferentJdksError(ModuleSourceSet.getModules((Collection)sourceSets));
                        return false;
                    }
                    LanguageLevel moduleLanguageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                    if (languageLevel == null) {
                        languageLevel = moduleLanguageLevel;
                        continue;
                    }
                    if (languageLevel.equals((Object)moduleLanguageLevel)) continue;
                    this.showCyclicModulesHaveDifferentLanguageLevel(ModuleSourceSet.getModules((Collection)sourceSets));
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            LOG.info(e);
            return false;
        }
    }

    private void showCyclicModulesHaveDifferentLanguageLevel(Set<Module> modulesInChunk) {
        Module firstModule = (Module)ContainerUtil.getFirstItem(modulesInChunk);
        LOG.assertTrue(firstModule != null);
        String moduleNameToSelect = firstModule.getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclicModulesHaveDifferentJdksError(Set<Module> modulesInChunk) {
        Module firstModule = (Module)ContainerUtil.getFirstItem(modulesInChunk);
        LOG.assertTrue(firstModule != null);
        String moduleNameToSelect = firstModule.getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getModulesString(Collection<Module> modulesInChunk) {
        StringBuilder moduleNames = StringBuilderSpinAllocator.alloc();
        try {
            for (Module module : modulesInChunk) {
                if (moduleNames.length() > 0) {
                    moduleNames.append("\n");
                }
                moduleNames.append("\"").append(module.getName()).append("\"");
            }
            String string = moduleNames.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)moduleNames);
        }
    }

    private static boolean hasSources(Module module, JavaSourceRootType rootType) {
        return !ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotSpecifiedError(@NonNls String resourceId, List<String> modules, String editorNameToSelect) {
        String message;
        String nameToSelect = null;
        StringBuilder names = StringBuilderSpinAllocator.alloc();
        try {
            int maxModulesToShow = 10;
            for (String name : modules.size() > 10 ? modules.subList(0, 10) : modules) {
                if (nameToSelect == null) {
                    nameToSelect = name;
                }
                if (names.length() > 0) {
                    names.append(",\n");
                }
                names.append("\"");
                names.append(name);
                names.append("\"");
            }
            if (modules.size() > 10) {
                names.append(",\n...");
            }
            message = CompilerBundle.message((String)resourceId, (Object[])new Object[]{modules.size(), names.toString()});
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)names);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message);
        }
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(nameToSelect, editorNameToSelect);
    }

    private void showConfigurationDialog(String moduleNameToSelect, String tabNameToSelect) {
        ProjectSettingsService.getInstance(this.myProject).showModuleConfigurationDialog(moduleNameToSelect, tabNameToSelect);
    }

    private static class MessagesActivationListener
    extends NotificationListener.Adapter {
        private final WeakReference<Project> myProjectRef;
        private final Object myContentId;

        public MessagesActivationListener(CompileContextImpl compileContext) {
            this.myProjectRef = new WeakReference<Project>(compileContext.getProject());
            this.myContentId = compileContext.getBuildSession().getContentId();
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/compiler/impl/CompileDriver$MessagesActivationListener", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/impl/CompileDriver$MessagesActivationListener", "hyperlinkActivated"));
            }
            Project project = (Project)this.myProjectRef.get();
            if (project != null && !project.isDisposed() && CompilerTask.showCompilerContent(project, this.myContentId)) {
                ToolWindow tw = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (tw != null) {
                    tw.activate(null, false);
                }
            } else {
                notification.expire();
            }
        }
    }
}

