/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaBreakpointTypeBase<T extends JavaBreakpointProperties>
extends XBreakpointType<XBreakpoint<T>, T> {
    protected JavaBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "<init>"));
        }
        super(id, title, true);
    }

    public final boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @Nullable
    public final XBreakpointCustomPropertiesPanel<XBreakpoint<T>> createCustomRightPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "createCustomRightPropertiesPanel"));
        }
        return new JavaBreakpointFiltersPanel(project);
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<T> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "getEditorsProvider"));
        }
        return new JavaDebuggerEditorsProvider();
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<T> breakpoint) {
        PsiClass aClass;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase", "getSourcePosition"));
        }
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null && (aClass = javaBreakpoint.getPsiClass()) != null && aClass.getContainingFile() != null && aClass.getTextOffset() >= 0) {
            return XDebuggerUtil.getInstance().createPositionByOffset(aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
        }
        return null;
    }
}

