/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.RunnerWinProcess;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class KillableColoredProcessHandler
extends ColoredProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableColoredProcessHandler.class);
    private boolean myShouldKillProcessSoftly;

    public KillableColoredProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
    }

    public KillableColoredProcessHandler(Process process, String commandLine, @NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myShouldKillProcessSoftly = true;
    }

    public KillableColoredProcessHandler(Process process, String commandLine) {
        super(process, commandLine);
        this.myShouldKillProcessSoftly = true;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canKillProcessSoftly() {
        if (KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.myProcess instanceof RunnerWinProcess;
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted = false;
        if (this.canKillProcessSoftly() && this.shouldKillProcessSoftly()) {
            gracefulTerminationAttempted = this.destroyProcessGracefully();
        }
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            if (this.myProcess instanceof RunnerWinProcess) {
                RunnerWinProcess runnerWinProcess = (RunnerWinProcess)this.myProcess;
                runnerWinProcess.destroyGracefully(true);
                return true;
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcess);
        }
        return false;
    }

    protected boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    @Override
    public boolean canKillProcess() {
        return KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.getProcess());
    }

    @Override
    public void killProcess() {
        this.killProcessTree(this.getProcess());
    }

    @NotNull
    public static KillableColoredProcessHandler create(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableColoredProcessHandler", "create"));
        }
        Process process = SystemInfo.isWindows ? RunnerWinProcess.create(commandLine) : commandLine.createProcess();
        KillableColoredProcessHandler killableColoredProcessHandler = new KillableColoredProcessHandler(process, commandLine.getCommandLineString(), commandLine.getCharset());
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/KillableColoredProcessHandler", "create"));
        }
        return killableColoredProcessHandler;
    }
}

