/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.config.AbstractProperty;

public class TestFrameworkActions {
    public static void installFilterAction(final TestFrameworkRunningModel model) {
        final TestConsoleProperties properties = model.getProperties();
        TestFrameworkPropertyListener<Boolean> hidePropertyListener = new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                model.setFilter(TestFrameworkActions.getFilter(properties));
            }
        };
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_PASSED_TESTS, hidePropertyListener, model, true);
        TestFrameworkPropertyListener<Boolean> ignorePropertyListener = new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                model.setFilter(TestFrameworkActions.getFilter(properties));
            }
        };
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_IGNORED_TEST, ignorePropertyListener, model, true);
    }

    private static Filter getFilter(TestConsoleProperties properties) {
        boolean shouldFilterPassed = TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)properties);
        Filter hidePassedFilter = shouldFilterPassed ? Filter.NOT_PASSED.or(Filter.DEFECT) : Filter.NO_FILTER;
        boolean shouldFilterIgnored = TestConsoleProperties.HIDE_IGNORED_TEST.value((AbstractProperty.AbstractPropertyContainer)properties);
        Filter hideIgnoredFilter = shouldFilterIgnored ? Filter.IGNORED.not() : Filter.NO_FILTER;
        return hidePassedFilter.and(hideIgnoredFilter);
    }

    public static void addPropertyListener(final AbstractProperty<Boolean> property, final TestFrameworkPropertyListener<Boolean> propertyListener, TestFrameworkRunningModel model, boolean sendValue) {
        final TestConsoleProperties properties = model.getProperties();
        if (sendValue) {
            properties.addListenerAndSendValue(property, propertyListener);
        } else {
            properties.addListener(property, propertyListener);
        }
        Disposer.register((Disposable)model, (Disposable)new Disposable(){

            public void dispose() {
                properties.removeListener(property, propertyListener);
            }
        });
    }
}

