/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    @NonNls
    public static final String PLUGIN_LIST_FILE = "availables.xml";

    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(@Nullable ProgressIndicator indicator) throws Exception {
        return RepositoryHelper.loadPluginsFromRepository(indicator, null);
    }

    @NotNull
    public static Pair<URLConnection, String> openConnection(@NotNull String initialUrl, boolean supportGzip) throws IOException {
        if (initialUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialUrl", "com/intellij/ide/plugins/RepositoryHelper", "openConnection"));
        }
        int i = 0;
        String url = initialUrl;
        while (i++ < 99) {
            int responseCode;
            URLConnection connection;
            if (ApplicationManager.getApplication() != null) {
                connection = HttpConfigurable.getInstance().openConnection(url);
            } else {
                connection = new URL(url).openConnection();
                connection.setConnectTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
                connection.setReadTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
            }
            if (supportGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            connection.setUseCaches(false);
            if (connection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)connection).getResponseCode()) != 200 && responseCode != 304) {
                url = responseCode == 301 || responseCode == 302 ? connection.getHeaderField("Location") : null;
                if (url == null) {
                    throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                }
                ((HttpURLConnection)connection).disconnect();
                continue;
            }
            Pair pair = Pair.create((Object)connection, (Object)(url == initialUrl ? null : url));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "openConnection"));
            }
            return pair;
        }
        throw new IOException("Infinite redirection");
    }

    @NotNull
    public static InputStream getConnectionInputStream(@NotNull URLConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/plugins/RepositoryHelper", "getConnectionInputStream"));
        }
        InputStream inputStream = connection.getInputStream();
        if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
            GZIPInputStream gZIPInputStream;
            block5: {
                try {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                    if (gZIPInputStream != null) break block5;
                }
                catch (IOException e) {
                    inputStream.close();
                    throw e;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "getConnectionInputStream"));
            }
            return gZIPInputStream;
        }
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "getConnectionInputStream"));
        }
        return inputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(@Nullable ProgressIndicator indicator, @Nullable BuildNumber buildnumber) throws Exception {
        File pluginListFile;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String url = appInfo.getPluginsListUrl() + "?build=" + (buildnumber != null ? buildnumber.asString() : appInfo.getApiVersion());
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
        }
        if ((pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE)).length() > 0L) {
            try {
                url = url + "&crc32=" + Files.hash((File)pluginListFile, (HashFunction)Hashing.crc32()).toString();
            }
            catch (NoSuchMethodError e) {
                String guavaPath = PathUtil.getJarPathForClass(Hashing.class);
                throw new RuntimeException(guavaPath, e);
            }
        }
        URLConnection connection = (URLConnection)RepositoryHelper.openConnection((String)url, (boolean)true).first;
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.waiting.for.reply.from.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
        }
        connection.connect();
        try {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                List<IdeaPluginDescriptor> list = RepositoryHelper.loadPluginList(pluginListFile);
                return list;
            }
            if (indicator != null) {
                indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[0]));
            }
            List<IdeaPluginDescriptor> list = RepositoryHelper.readPluginsStream(connection, indicator, PLUGIN_LIST_FILE);
            return list;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized List<IdeaPluginDescriptor> readPluginsStream(@NotNull URLConnection connection, @Nullable ProgressIndicator indicator, @NotNull String file) throws Exception {
        File localFile;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/plugins/RepositoryHelper", "readPluginsStream"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "readPluginsStream"));
        }
        InputStream input = RepositoryHelper.getConnectionInputStream(connection);
        try {
            localFile = RepositoryHelper.createLocalPluginsDescriptions(file);
            FileOutputStream output = new FileOutputStream(localFile);
            try {
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)input, (OutputStream)output, (int)connection.getContentLength());
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        finally {
            input.close();
        }
        return RepositoryHelper.loadPluginList(localFile);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(File file) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        RepositoryContentHandler handler = new RepositoryContentHandler();
        parser.parse(file, (DefaultHandler)handler);
        return handler.getPluginsList();
    }

    @NotNull
    private static File createLocalPluginsDescriptions(@NotNull String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "createLocalPluginsDescriptions"));
        }
        File basePath = new File(PathManager.getPluginsPath());
        if (!basePath.isDirectory() && !basePath.mkdirs()) {
            throw new IOException("Cannot create directory: " + basePath);
        }
        File temp = new File(basePath, file);
        if (temp.exists()) {
            FileUtil.delete((File)temp);
        } else {
            FileUtilRt.createParentDirs((File)temp);
        }
        File file2 = temp;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "createLocalPluginsDescriptions"));
        }
        return file2;
    }

    public static List<IdeaPluginDescriptor> loadPluginsFromDescription(@NotNull URLConnection connection, @Nullable ProgressIndicator indicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/plugins/RepositoryHelper", "loadPluginsFromDescription"));
        }
        return RepositoryHelper.readPluginsStream(connection, indicator, "host.xml");
    }

    public static String getDownloadUrl() {
        return ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl() + "?action=download&id=";
    }
}

