/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchpadFileSystem
extends DummyFileSystem {
    private static final String PROTOCOL = "scratchpad";
    private final Map<String, VirtualFile> myCachedFiles = ContainerUtil.newHashMap();

    public static ScratchpadFileSystem getScratchFileSystem() {
        return (ScratchpadFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public void removeByPrefix(final @NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ide/scratch/ScratchpadFileSystem", "removeByPrefix"));
        }
        List toRemove = ContainerUtil.findAll(this.myCachedFiles.keySet(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return s.startsWith(prefix);
            }
        });
        for (String s : toRemove) {
            this.myCachedFiles.remove(s);
        }
    }

    @Override
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/scratch/ScratchpadFileSystem", "findFileByPath"));
        }
        VirtualFile file = this.myCachedFiles.get(path);
        if (file != null && file.isValid()) {
            return file;
        }
        return null;
    }

    @NotNull
    public VirtualFile addFile(@NotNull String name, @NotNull Language language, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/scratch/ScratchpadFileSystem", "addFile"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchpadFileSystem", "addFile"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ide/scratch/ScratchpadFileSystem", "addFile"));
        }
        MyLightVirtualFile file = new MyLightVirtualFile(name, language, prefix);
        this.myCachedFiles.put(file.getPath(), (VirtualFile)file);
        MyLightVirtualFile myLightVirtualFile = file;
        if (myLightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadFileSystem", "addFile"));
        }
        return myLightVirtualFile;
    }

    @Override
    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/scratch/ScratchpadFileSystem", "extractPresentableUrl"));
        }
        String string = ScratchpadFileSystem.calcSuffix(this.findFileByPath(path));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadFileSystem", "extractPresentableUrl"));
        }
        return string;
    }

    private static String calcSuffix(@Nullable VirtualFile file) {
        return file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage().getDisplayName() : "Unknown language";
    }

    public static class ScratchPresentation
    extends PresentationProvider<LightVirtualFile> {
        public Icon getIcon(@NotNull LightVirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchpadFileSystem$ScratchPresentation", "getIcon"));
            }
            return LayeredIcon.create((Icon)file.getFileType().getIcon(), (Icon)AllIcons.Actions.New);
        }
    }

    @Presentation(provider=ScratchPresentation.class)
    public static class MyLightVirtualFile
    extends LightVirtualFile {
        private final String myPrefix;

        public MyLightVirtualFile(@NotNull String fileName, @NotNull Language language, @NotNull String projectPrefix) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/scratch/ScratchpadFileSystem$MyLightVirtualFile", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchpadFileSystem$MyLightVirtualFile", "<init>"));
            }
            if (projectPrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPrefix", "com/intellij/ide/scratch/ScratchpadFileSystem$MyLightVirtualFile", "<init>"));
            }
            super(fileName, language, (CharSequence)"");
            this.myPrefix = projectPrefix;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            ScratchpadFileSystem scratchpadFileSystem = ScratchpadFileSystem.getScratchFileSystem();
            if (scratchpadFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadFileSystem$MyLightVirtualFile", "getFileSystem"));
            }
            return scratchpadFileSystem;
        }

        @NotNull
        public String getPath() {
            String string = this.myPrefix + super.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadFileSystem$MyLightVirtualFile", "getPath"));
            }
            return string;
        }
    }
}

