/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassModel2
extends FilteringGotoByModel<Language> {
    private String[] mySeparators;

    public GotoClassModel2(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/gotoByName/GotoClassModel2", "<init>"));
        }
        super(project, ChooseByNameRegistry.getInstance().getClassModelContributors());
    }

    @Override
    protected Language filterValueFor(NavigationItem item) {
        return item instanceof PsiElement ? ((PsiElement)item).getLanguage() : null;
    }

    @Override
    protected synchronized Collection<Language> getFilterItems() {
        Collection<Language> result = super.getFilterItems();
        if (result == null) {
            return result;
        }
        HashSet<Language> items = new HashSet<Language>(result);
        items.add(Language.ANY);
        return items;
    }

    @Nullable
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.include.non.project.classes", (Object[])new Object[0]);
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.matches.found.in.project", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return SystemInfo.isMac ? (char)'P' : 'n';
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.includeLibraries"));
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToClass.includeLibraries", Boolean.toString(state));
        }
    }

    public String getFullName(Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        for (ChooseByNameContributor c : this.getContributors()) {
            String result;
            if (!(c instanceof GotoClassContributor) || (result = ((GotoClassContributor)c).getQualifiedName((NavigationItem)element)) == null) continue;
            return result;
        }
        return this.getElementName(element);
    }

    @NotNull
    public String[] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        if (this.mySeparators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "getSeparators"));
        }
        return this.mySeparators;
    }

    public static String[] getSeparatorsFromContributors(ChooseByNameContributor[] contributors) {
        HashSet<String> separators = new HashSet<String>();
        separators.add(".");
        for (ChooseByNameContributor c : contributors) {
            if (!(c instanceof GotoClassContributor)) continue;
            separators.add(((GotoClassContributor)c).getQualifiedNameSeparator());
        }
        return separators.toArray(new String[separators.size()]);
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
        }
        if (pattern.startsWith("@")) {
            String string = pattern.substring(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
        }
        return string;
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }
}

