/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.PatchedUsage;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.connect.RemotelyConfigurableStatisticsService;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsHttpClientSender;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsUploadAssistant {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.statistic.StatisticsUploadAssistant");
    private static final KeyedExtensionCollector<StatisticsService, String> COLLECTOR = new KeyedExtensionCollector("com.intellij.statisticsService");

    public String getData() {
        return this.getData(Collections.<String>emptySet());
    }

    public static boolean showNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 86400000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(SentUsagesPersistence settings) {
        return settings != null && settings.isAllowed();
    }

    public String getData(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getData"));
        }
        return StatisticsUploadAssistant.getStringPatch(disabledGroups, ProjectManager.getInstance().getOpenProjects());
    }

    public static void persistSentPatch(@NotNull String patchStr) {
        if (patchStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchStr", "com/intellij/internal/statistic/StatisticsUploadAssistant", "persistSentPatch"));
        }
        StatisticsUploadAssistant.persistSentPatch(patchStr, UsageStatisticsPersistenceComponent.getInstance());
    }

    public static void persistSentPatch(@NotNull String patchStr, @NotNull SentUsagesPersistence persistenceComponent) {
        if (patchStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchStr", "com/intellij/internal/statistic/StatisticsUploadAssistant", "persistSentPatch"));
        }
        if (persistenceComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceComponent", "com/intellij/internal/statistic/StatisticsUploadAssistant", "persistSentPatch"));
        }
        Map<GroupDescriptor, Set<PatchedUsage>> patchedUsages = StatisticsUploadAssistant.mapToPatchedUsagesMap(ConvertUsagesUtil.convertString(patchStr));
        if (patchedUsages.size() > 0) {
            persistenceComponent.persistPatch(patchedUsages);
        }
    }

    @NotNull
    public static String getStringPatch(@NotNull Set<String> disabledGroups, Project ... project) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        String string = StatisticsUploadAssistant.getStringPatch(disabledGroups, project, UsageStatisticsPersistenceComponent.getInstance(), 0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        return string;
    }

    @NotNull
    public static String getStringPatch(@NotNull Set<String> disabledGroups, @NotNull Project[] projects, @NotNull SentUsagesPersistence usagesPersistence, int maxSize) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        if (usagesPersistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usagesPersistence", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        Map<GroupDescriptor, Set<PatchedUsage>> patchedUsages = StatisticsUploadAssistant.getPatchedUsages(disabledGroups, projects, usagesPersistence);
        String string = StatisticsUploadAssistant.getStringPatch(patchedUsages, maxSize);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        return string;
    }

    public static String getStringPatch(@NotNull Map<GroupDescriptor, Set<PatchedUsage>> patchedUsages, int maxSize) {
        if (patchedUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchedUsages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getStringPatch"));
        }
        if (patchedUsages.size() == 0) {
            return "";
        }
        String patchStr = ConvertUsagesUtil.convertUsages(patchedUsages);
        if (maxSize > 0 && patchStr.getBytes().length > maxSize) {
            patchStr = ConvertUsagesUtil.cutPatchString(patchStr, maxSize);
        }
        return patchStr;
    }

    @NotNull
    public static Map<GroupDescriptor, Set<PatchedUsage>> getPatchedUsages(@NotNull Set<String> disabledGroups, @NotNull Project[] projects, @NotNull SentUsagesPersistence usagesPersistence) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        if (usagesPersistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usagesPersistence", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        LinkedHashMap<GroupDescriptor, Set<PatchedUsage>> usages = new LinkedHashMap<GroupDescriptor, Set<PatchedUsage>>();
        for (Project project : projects) {
            Map<GroupDescriptor, Set<UsageDescriptor>> allUsages = StatisticsUploadAssistant.getAllUsages(project, disabledGroups);
            Map<GroupDescriptor, Set<UsageDescriptor>> sentUsages = StatisticsUploadAssistant.filterDisabled(disabledGroups, usagesPersistence.getSentUsages());
            usages.putAll(StatisticsUploadAssistant.getPatchedUsages(allUsages, sentUsages));
        }
        LinkedHashMap<GroupDescriptor, Set<PatchedUsage>> linkedHashMap = usages;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        return linkedHashMap;
    }

    @NotNull
    private static Map<GroupDescriptor, Set<UsageDescriptor>> filterDisabled(@NotNull Set<String> disabledGroups, @NotNull Map<GroupDescriptor, Set<UsageDescriptor>> usages) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "filterDisabled"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "filterDisabled"));
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> filtered = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (Map.Entry<GroupDescriptor, Set<UsageDescriptor>> usage : usages.entrySet()) {
            if (disabledGroups.contains(usage.getKey().getId())) continue;
            filtered.put(usage.getKey(), usage.getValue());
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> linkedHashMap = filtered;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "filterDisabled"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Map<GroupDescriptor, Set<PatchedUsage>> getPatchedUsages(@NotNull Map<GroupDescriptor, Set<UsageDescriptor>> allUsages, @NotNull SentUsagesPersistence usagesPersistence) {
        if (allUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        if (usagesPersistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usagesPersistence", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        Map<GroupDescriptor, Set<PatchedUsage>> map = StatisticsUploadAssistant.getPatchedUsages(allUsages, usagesPersistence.getSentUsages());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        return map;
    }

    @NotNull
    public static Map<GroupDescriptor, Set<PatchedUsage>> getPatchedUsages(@NotNull Map<GroupDescriptor, Set<UsageDescriptor>> allUsages, Map<GroupDescriptor, Set<UsageDescriptor>> sentUsageMap) {
        if (allUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        Map patchedUsages = StatisticsUploadAssistant.mapToPatchedUsagesMap(allUsages);
        for (Map.Entry<GroupDescriptor, Set<UsageDescriptor>> sentUsageEntry : sentUsageMap.entrySet()) {
            GroupDescriptor sentUsageGroupDescriptor = sentUsageEntry.getKey();
            Set<UsageDescriptor> sentUsages = sentUsageEntry.getValue();
            for (UsageDescriptor sentUsage : sentUsages) {
                PatchedUsage descriptor = (PatchedUsage)StatisticsUploadAssistant.findDescriptor(patchedUsages, (Pair<GroupDescriptor, String>)Pair.create((Object)sentUsageGroupDescriptor, (Object)sentUsage.getKey()));
                if (descriptor == null) {
                    if (!patchedUsages.containsKey(sentUsageGroupDescriptor)) {
                        patchedUsages.put(sentUsageGroupDescriptor, new LinkedHashSet());
                    }
                    patchedUsages.get(sentUsageGroupDescriptor).add(new PatchedUsage(sentUsage.getKey(), -sentUsage.getValue()));
                    continue;
                }
                descriptor.subValue(sentUsage.getValue());
            }
        }
        Map<GroupDescriptor, Set<PatchedUsage>> map = StatisticsUploadAssistant.packCollection(patchedUsages, new Condition<PatchedUsage>(){

            public boolean value(PatchedUsage patchedUsage) {
                return patchedUsage.getDelta() != 0;
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getPatchedUsages"));
        }
        return map;
    }

    private static Map<GroupDescriptor, Set<PatchedUsage>> mapToPatchedUsagesMap(Map<GroupDescriptor, Set<UsageDescriptor>> allUsages) {
        LinkedHashMap<GroupDescriptor, Set<PatchedUsage>> patchedUsages = new LinkedHashMap<GroupDescriptor, Set<PatchedUsage>>();
        for (Map.Entry<GroupDescriptor, Set<UsageDescriptor>> entry : allUsages.entrySet()) {
            patchedUsages.put(entry.getKey(), new HashSet(ContainerUtil.map2Set((Collection)entry.getValue(), (Function)new Function<UsageDescriptor, PatchedUsage>(){

                public PatchedUsage fun(UsageDescriptor usageDescriptor) {
                    return new PatchedUsage(usageDescriptor);
                }
            })));
        }
        return patchedUsages;
    }

    @NotNull
    private static Map<GroupDescriptor, Set<PatchedUsage>> packCollection(@NotNull Map<GroupDescriptor, Set<PatchedUsage>> patchedUsages, Condition<PatchedUsage> condition) {
        if (patchedUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchedUsages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "packCollection"));
        }
        LinkedHashMap<GroupDescriptor, Set<PatchedUsage>> result = new LinkedHashMap<GroupDescriptor, Set<PatchedUsage>>();
        for (GroupDescriptor descriptor : patchedUsages.keySet()) {
            Set<PatchedUsage> usages = StatisticsUploadAssistant.packCollection((Collection)patchedUsages.get(descriptor), condition);
            if (usages.size() <= 0) continue;
            result.put(descriptor, usages);
        }
        LinkedHashMap<GroupDescriptor, Set<PatchedUsage>> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "packCollection"));
        }
        return linkedHashMap;
    }

    @NotNull
    private static <T> Set<T> packCollection(@NotNull Collection<T> set, @NotNull Condition<T> condition) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/internal/statistic/StatisticsUploadAssistant", "packCollection"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/internal/statistic/StatisticsUploadAssistant", "packCollection"));
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T t : set) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        LinkedHashSet<T> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "packCollection"));
        }
        return linkedHashSet;
    }

    @Nullable
    public static <T extends UsageDescriptor> T findDescriptor(@NotNull Map<GroupDescriptor, Set<T>> descriptors, final @NotNull Pair<GroupDescriptor, String> id) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/internal/statistic/StatisticsUploadAssistant", "findDescriptor"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/internal/statistic/StatisticsUploadAssistant", "findDescriptor"));
        }
        Set<T> usages = descriptors.get(id.getFirst());
        if (usages == null) {
            return null;
        }
        return (T)((UsageDescriptor)ContainerUtil.find(usages, (Condition)new Condition<T>(){

            public boolean value(T t) {
                return ((String)id.getSecond()).equals(((UsageDescriptor)t).getKey());
            }
        }));
    }

    @NotNull
    public static Map<GroupDescriptor, Set<UsageDescriptor>> getAllUsages(@Nullable Project project, @NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getAllUsages"));
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (UsagesCollector usagesCollector : (UsagesCollector[])Extensions.getExtensions(UsagesCollector.EP_NAME)) {
            GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
            if (disabledGroups.contains(groupDescriptor.getId())) continue;
            try {
                Set<UsageDescriptor> usages = usagesCollector.getUsages(project);
                usageDescriptors.put(groupDescriptor, usages);
            }
            catch (CollectUsagesException e) {
                LOG.info((Throwable)e);
            }
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getAllUsages"));
        }
        return linkedHashMap;
    }

    public static StatisticsService getStatisticsService() {
        StatisticsService service;
        String key = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsServiceKey();
        StatisticsService statisticsService = service = key == null ? null : (StatisticsService)COLLECTOR.findSingle((Object)key);
        if (service != null) {
            return service;
        }
        return new RemotelyConfigurableStatisticsService(new StatisticsConnectionService(), new StatisticsHttpClientSender(), new StatisticsUploadAssistant());
    }
}

