/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemConfigurable<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final List<ExternalSystemSettingsControl<ProjectSettings>> myProjectSettingsControls;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    @Nullable
    private ExternalSystemSettingsControl<SystemSettings> mySystemSettingsControl;
    @Nullable
    private ExternalSystemSettingsControl<ProjectSettings> myActiveProjectSettingsControl;
    private PaintAwarePanel myComponent;
    private JBList myProjectsList;
    private DefaultListModel myProjectsModel;

    protected AbstractExternalSystemConfigurable(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "<init>"));
        }
        this.myProjectSettingsControls = ContainerUtilRt.newArrayList();
        this.myProject = project;
        this.myExternalSystemId = externalSystemId;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new PaintAwarePanel(new GridBagLayout());
            SystemSettings settings = this.getSettings();
            this.prepareProjectSettings(settings);
            this.prepareSystemSettings(settings);
            ExternalSystemUiUtil.fillBottom(this.myComponent);
        }
        return this.myComponent;
    }

    @NotNull
    private SystemSettings getSettings() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        assert (manager != null);
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        if (abstractExternalSystemSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "getSettings"));
        }
        return (SystemSettings)abstractExternalSystemSettings;
    }

    private void prepareProjectSettings(@NotNull SystemSettings s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "prepareProjectSettings"));
        }
        this.myProjectsModel = new DefaultListModel();
        this.myProjectsList = new JBList((ListModel)this.myProjectsModel);
        this.myProjectsList.setSelectionMode(0);
        this.addTitle(ExternalSystemBundle.message((String)"settings.title.linked.projects", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}));
        this.myComponent.add((Component)new JBScrollPane((Component)this.myProjectsList), ExternalSystemUiUtil.getFillLineConstraints(1));
        this.addTitle(ExternalSystemBundle.message((String)"settings.title.project.settings", (Object[])new Object[0]));
        ArrayList settings = ContainerUtilRt.newArrayList((Iterable)s.getLinkedProjectsSettings());
        this.myProjectsList.setVisibleRowCount(Math.max(3, Math.min(5, settings.size())));
        ContainerUtil.sort((List)settings, (Comparator)new Comparator<ProjectSettings>(){

            @Override
            public int compare(ProjectSettings s1, ProjectSettings s2) {
                return AbstractExternalSystemConfigurable.this.getProjectName(s1.getExternalProjectPath()).compareTo(AbstractExternalSystemConfigurable.this.getProjectName(s2.getExternalProjectPath()));
            }
        });
        this.myProjectSettingsControls.clear();
        for (ExternalProjectSettings setting : settings) {
            ExternalSystemSettingsControl<ExternalProjectSettings> control = this.createProjectSettingsControl(setting);
            control.fillUi(this.myComponent, 1);
            this.myProjectsModel.addElement(this.getProjectName(setting.getExternalProjectPath()));
            this.myProjectSettingsControls.add(control);
            control.showUi(false);
        }
        this.myProjectsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int i = AbstractExternalSystemConfigurable.this.myProjectsList.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                if (AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl != null) {
                    AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl.showUi(false);
                }
                AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl = (ExternalSystemSettingsControl)AbstractExternalSystemConfigurable.this.myProjectSettingsControls.get(i);
                AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl.showUi(true);
            }
        });
        if (!this.myProjectsModel.isEmpty()) {
            this.myProjectsList.setSelectedIndex(0);
        }
    }

    private void addTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "addTitle"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
        this.myComponent.add((Component)panel, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @NotNull
    protected String getProjectName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "getProjectName"));
        }
        File file = new File(path);
        String string = file.isDirectory() || file.getParentFile() == null ? file.getName() : file.getParentFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "getProjectName"));
        }
        return string;
    }

    private void prepareSystemSettings(@NotNull SystemSettings s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable", "prepareSystemSettings"));
        }
        this.mySystemSettingsControl = this.createSystemSettingsControl(s);
        if (this.mySystemSettingsControl != null) {
            this.addTitle(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}));
            this.mySystemSettingsControl.fillUi(this.myComponent, 1);
        }
    }

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    public boolean isModified() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            if (!control.isModified()) continue;
            return true;
        }
        return this.mySystemSettingsControl != null && this.mySystemSettingsControl.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        SystemSettings systemSettings = this.getSettings();
        ExternalSystemSettingsListener publisher = systemSettings.getPublisher();
        publisher.onBulkChangeStart();
        try {
            ArrayList projectSettings = ContainerUtilRt.newArrayList();
            for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
                ProjectSettings s = this.newProjectSettings();
                control.apply(s);
                projectSettings.add(s);
            }
            systemSettings.setLinkedProjectsSettings((Collection)projectSettings);
            for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
                if (!(control instanceof AbstractExternalProjectSettingsControl)) continue;
                ((AbstractExternalProjectSettingsControl)AbstractExternalProjectSettingsControl.class.cast(control)).updateInitialSettings();
            }
            if (this.mySystemSettingsControl != null) {
                this.mySystemSettingsControl.apply(systemSettings);
            }
        }
        finally {
            publisher.onBulkChangeEnd();
        }
    }

    @NotNull
    protected abstract ProjectSettings newProjectSettings();

    public void reset() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            control.reset();
        }
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.reset();
        }
    }

    public void disposeUIResources() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            control.disposeUIResources();
        }
        this.myProjectSettingsControls.clear();
        this.myComponent = null;
        this.myProjectsList = null;
        this.myProjectsModel = null;
        this.mySystemSettingsControl = null;
    }
}

