/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlatformRefactoringAction
extends BaseRefactoringAction {
    private Boolean myHidden = null;
    private final Condition<RefactoringSupportProvider> myCondition = new Condition<RefactoringSupportProvider>(){

        public boolean value(RefactoringSupportProvider provider) {
            return BasePlatformRefactoringAction.this.getRefactoringHandler(provider) != null;
        }
    };

    public BasePlatformRefactoringAction() {
        LanguageRefactoringSupport.INSTANCE.addListener((ExtensionPointListener)new ExtensionPointListener<RefactoringSupportProvider>(){

            public void extensionAdded(@NotNull RefactoringSupportProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/refactoring/actions/BasePlatformRefactoringAction$2", "extensionAdded"));
                }
                BasePlatformRefactoringAction.this.myHidden = null;
            }

            public void extensionRemoved(@NotNull RefactoringSupportProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/refactoring/actions/BasePlatformRefactoringAction$2", "extensionRemoved"));
                }
                BasePlatformRefactoringAction.this.myHidden = null;
            }
        });
    }

    @Override
    protected final RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        Language[] languages;
        RefactoringActionHandler handler;
        RefactoringActionHandler handler2;
        RefactoringActionHandler handler3;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "getHandler"));
        }
        PsiElement element = null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor != null && file != null && (element = BasePlatformRefactoringAction.getElementAtCaret(editor, file)) != null && (handler3 = this.getHandler(element.getLanguage(), element)) != null) {
            return handler3;
        }
        PsiElement referenced = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (referenced != null && (handler2 = this.getHandler(referenced.getLanguage(), referenced)) != null) {
            return handler2;
        }
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElements != null && psiElements.length > 1 && (handler = this.getHandler(psiElements[0].getLanguage(), psiElements[0])) != null && this.isEnabledOnElements(psiElements)) {
            return handler;
        }
        if (element == null) {
            element = referenced;
        }
        if ((languages = (Language[])LangDataKeys.CONTEXT_LANGUAGES.getData(dataContext)) != null) {
            for (Language language : languages) {
                RefactoringActionHandler handler4 = this.getHandler(language, element);
                if (handler4 == null) continue;
                return handler4;
            }
        }
        return null;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "getHandler"));
        }
        List providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language);
        if (providers.isEmpty()) {
            return null;
        }
        if (element == null) {
            return this.getRefactoringHandler((RefactoringSupportProvider)providers.get(0));
        }
        for (RefactoringSupportProvider provider : providers) {
            if (!provider.isAvailable(element)) continue;
            return this.getRefactoringHandler(provider, element);
        }
        return null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "isAvailableOnElementInEditorAndFile"));
        }
        return this.getHandler(context) != null;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        List providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language);
        return ContainerUtil.find((Iterable)providers, this.myCondition) != null;
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "isEnabledOnElements"));
        }
        if (elements.length > 0) {
            Language language = elements[0].getLanguage();
            RefactoringActionHandler handler = this.getHandler(language, elements[0]);
            return handler instanceof ElementsHandler && ((ElementsHandler)handler).isEnabledOnElements(elements);
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider var1);

    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider, PsiElement element) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/BasePlatformRefactoringAction", "getRefactoringHandler"));
        }
        return this.getRefactoringHandler(provider);
    }

    @Override
    protected boolean isHidden() {
        if (this.myHidden == null) {
            this.myHidden = this.calcHidden();
        }
        return this.myHidden;
    }

    private boolean calcHidden() {
        for (Language l : Language.getRegisteredLanguages()) {
            if (!this.isAvailableForLanguage(l)) continue;
            return false;
        }
        return true;
    }
}

