/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    private final boolean myMakeClassParameter;
    private final String myClassParameterName;
    private final boolean myMakeFieldParameters;
    private final HashMap<PsiField, String> myFieldToNameMapping;
    private final ArrayList<FieldParameter> myFieldToNameList;
    private final boolean myReplaceUsages;

    public Settings(boolean replaceUsages, @Nullable String classParameterName, @Nullable VariableData[] variableDatum) {
        this.myReplaceUsages = replaceUsages;
        this.myMakeClassParameter = classParameterName != null;
        this.myClassParameterName = classParameterName;
        this.myMakeFieldParameters = variableDatum != null;
        this.myFieldToNameList = new ArrayList();
        if (this.myMakeFieldParameters) {
            this.myFieldToNameMapping = new HashMap();
            for (VariableData data : variableDatum) {
                if (!data.passAsParameter) continue;
                this.myFieldToNameMapping.put((Object)((PsiField)data.variable), (Object)data.name);
                this.myFieldToNameList.add(new FieldParameter((PsiField)data.variable, data.name, data.type));
            }
        } else {
            this.myFieldToNameMapping = null;
        }
    }

    public Settings(boolean replaceUsages, String classParameterName, PsiField[] fields, String[] names) {
        this.myReplaceUsages = replaceUsages;
        this.myMakeClassParameter = classParameterName != null;
        this.myClassParameterName = classParameterName;
        this.myMakeFieldParameters = fields.length > 0;
        this.myFieldToNameList = new ArrayList();
        if (this.myMakeFieldParameters) {
            this.myFieldToNameMapping = new HashMap();
            for (int i = 0; i < fields.length; ++i) {
                PsiField field = fields[i];
                String name = names[i];
                this.myFieldToNameMapping.put((Object)field, (Object)name);
                this.myFieldToNameList.add(new FieldParameter(field, name, field.getType()));
            }
        } else {
            this.myFieldToNameMapping = null;
        }
    }

    public boolean isReplaceUsages() {
        return this.myReplaceUsages;
    }

    public boolean isMakeClassParameter() {
        return this.myMakeClassParameter;
    }

    public String getClassParameterName() {
        return this.myClassParameterName;
    }

    public boolean isMakeFieldParameters() {
        return this.myMakeFieldParameters;
    }

    @Nullable
    public String getNameForField(PsiField field) {
        if (this.myFieldToNameMapping != null) {
            return (String)this.myFieldToNameMapping.get((Object)field);
        }
        return null;
    }

    public List<FieldParameter> getParameterOrderList() {
        return this.myFieldToNameList;
    }

    public boolean isChangeSignature() {
        return this.isMakeClassParameter() || this.isMakeFieldParameters();
    }

    public int getNewParametersNumber() {
        int result = this.isMakeFieldParameters() ? this.myFieldToNameList.size() : 0;
        return result + (this.isMakeClassParameter() ? 1 : 0);
    }

    public static final class FieldParameter {
        public final PsiField field;
        public final String name;
        public final PsiType type;

        public FieldParameter(PsiField field, String name, PsiType type) {
            this.field = field;
            this.name = name;
            this.type = type;
        }
    }
}

