/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerOptions;
import org.jetbrains.annotations.NotNull;

public class MoveJavaInnerHandler
implements MoveInnerHandler {
    @Override
    @NotNull
    public PsiClass copyClass(@NotNull MoveInnerOptions options) {
        PsiClass newClass;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/refactoring/move/moveInner/MoveJavaInnerHandler", "copyClass"));
        }
        PsiClass innerClass = options.getInnerClass();
        if (options.getTargetContainer() instanceof PsiDirectory) {
            newClass = this.createNewClass(options);
            PsiDocComment defaultDocComment = newClass.getDocComment();
            if (defaultDocComment != null && innerClass.getDocComment() == null) {
                innerClass = (PsiClass)innerClass.addAfter((PsiElement)defaultDocComment, null).getParent();
            }
            newClass = (PsiClass)newClass.replace((PsiElement)innerClass);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"private", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"protected", (boolean)false);
            boolean makePublic = MoveJavaInnerHandler.needPublicAccess(options.getOuterClass(), options.getTargetContainer());
            if (makePublic) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"public", (boolean)true);
            }
        } else {
            newClass = (PsiClass)options.getTargetContainer().add((PsiElement)innerClass);
        }
        newClass.setName(options.getNewClassName());
        PsiClass psiClass = newClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveInner/MoveJavaInnerHandler", "copyClass"));
        }
        return psiClass;
    }

    protected PsiClass createNewClass(MoveInnerOptions options) {
        return JavaDirectoryService.getInstance().createClass((PsiDirectory)options.getTargetContainer(), options.getNewClassName());
    }

    protected static boolean needPublicAccess(PsiClass outerClass, PsiElement targetContainer) {
        if (outerClass.isInterface()) {
            return true;
        }
        if (targetContainer instanceof PsiDirectory) {
            PsiPackage targetPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)targetContainer);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)outerClass.getProject());
            if (targetPackage != null && !psiFacade.isInPackage((PsiElement)outerClass, targetPackage)) {
                return true;
            }
        }
        return false;
    }
}

