/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;

public class ElementToArrayConversionRule
extends TypeConversionRule {
    @Override
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        if (member == null && to instanceof PsiArrayType && TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)to).getComponentType(), (PsiType)from)) {
            TypeConversionDescriptor wrapDescription = new TypeConversionDescriptor("$qualifier$", "new " + from.getCanonicalText() + "[]{$qualifier$}", context);
            if (((PsiArrayType)to).getComponentType() instanceof PsiClassType && from instanceof PsiPrimitiveType) {
                String boxedTypeName = ((PsiPrimitiveType)from).getBoxedTypeName();
                String normalizedArrayInitializer = PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) ? "$qualifier$" : boxedTypeName + ".valueOf($qualifier$)";
                wrapDescription = new TypeConversionDescriptor("$qualifier$", "new " + boxedTypeName + "[]{" + normalizedArrayInitializer + "}", context);
            }
            PsiElement parent = context.getParent();
            if ((context instanceof PsiLiteralExpression || context instanceof PsiReferenceExpression) && parent instanceof PsiStatement) {
                return wrapDescription;
            }
            if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getRExpression() == context) {
                return wrapDescription;
            }
        }
        return null;
    }
}

