/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;

public class EscapeSequenceTokenizer {
    public static void processTextWithOffsets(PsiElement element, TokenConsumer consumer, StringBuilder unescapedText, int[] offsets, int startOffset) {
        StringBuilder currentToken = new StringBuilder();
        int currentTokenStart = startOffset;
        for (int i = 0; i < unescapedText.length(); ++i) {
            if (offsets[i + 1] - offsets[i] == 1) {
                if (currentToken.length() == 0) {
                    currentTokenStart = offsets[i] + startOffset;
                }
                currentToken.append(unescapedText.charAt(i));
                continue;
            }
            if (currentToken.length() <= 0) continue;
            EscapeSequenceTokenizer.processCurrentToken(element, currentToken, currentTokenStart, consumer);
            currentToken.setLength(0);
        }
        if (currentToken.length() > 0) {
            EscapeSequenceTokenizer.processCurrentToken(element, currentToken, currentTokenStart, consumer);
        }
    }

    private static void processCurrentToken(PsiElement element, StringBuilder currentToken, int currentTokenStart, TokenConsumer consumer) {
        String token = currentToken.toString();
        consumer.consumeToken(element, token, false, currentTokenStart, TextRange.allOf((String)token), PlainTextSplitter.getInstance());
    }
}

