/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.predicates.AbstractStringBasedPredicate;

public class WithinPredicate
extends AbstractStringBasedPredicate {
    private final MatchOptions myMatchOptions = new MatchOptions();
    private Matcher matcher;

    public WithinPredicate(String name, String within, Project project) {
        super(name, within);
        this.myMatchOptions.setLooseMatching(true);
        String unquoted = StringUtil.stripQuotesAroundValue((String)within);
        if (!unquoted.equals(within)) {
            this.myMatchOptions.setSearchPattern(unquoted);
            PatternCompiler.transformOldPattern(this.myMatchOptions);
            this.matcher = new Matcher(project, this.myMatchOptions);
        } else assert (false);
    }

    @Override
    public boolean match(PsiElement node, PsiElement match, int start, int end, MatchContext context) {
        MatchResult result = this.matcher.isMatchedByDownUp(match, this.myMatchOptions);
        return result != null;
    }
}

