/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.generation.actions.CommentByLineCommentAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.LightCodeInsightTestCase");
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    @Parameterized.Parameter(value=0)
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTest() throws Throwable {
        if (this.isRunInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), (ThrowableComputable)new ThrowableComputable<Void, Throwable>(){

                public Void compute() throws Throwable {
                    LightPlatformCodeInsightTestCase.this.doRunTest();
                    return null;
                }
            });
        } else {
            new WriteCommandAction.Simple(LightPlatformCodeInsightTestCase.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    LightPlatformCodeInsightTestCase.this.doRunTest();
                }
            }.performCommand();
        }
    }

    protected void doRunTest() throws Throwable {
        LightPlatformCodeInsightTestCase.super.runTest();
    }

    protected boolean isRunInWriteAction() {
        return true;
    }

    protected void configureByFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureByFile"));
        }
        try {
            File ioFile = new File(this.getTestDataPath() + filePath);
            String fileText = FileUtilRt.loadFile((File)ioFile, (String)"UTF-8", (boolean)true);
            LightPlatformCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            String string = this.myTestDataPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
            }
            return string;
        }
        String string = PathManagerEx.getTestDataPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
        }
        return string;
    }

    protected VirtualFile getVirtualFile(@NonNls String filePath) {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        return vFile;
    }

    @NotNull
    protected static Document configureFromFileText(final @NonNls @NotNull String fileName, final @NonNls @NotNull String fileText) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        Document document = (Document)new WriteCommandAction<Document>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Document> result) throws Throwable {
                Document document;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$3", "run"));
                }
                if (myVFile != null) {
                    PsiDocumentManager.getInstance((Project)LightPlatformTestCase.ourProject).commitAllDocuments();
                    FileEditorManager.getInstance((Project)LightPlatformTestCase.ourProject).closeFile(myVFile);
                    try {
                        myVFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    myVFile = null;
                }
                DocumentImpl fakeDocument = new DocumentImpl(fileText);
                EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
                String newFileText = fakeDocument.getText();
                try {
                    document = LightPlatformCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                EditorTestUtil.setCaretsAndSelection(myEditor, caretsState);
                LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
                result.setResult((Object)document);
            }
        }.execute().getResultObject();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        return document;
    }

    protected static Editor createEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createEditor"));
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), file, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).restart();
        ((EditorImpl)editor).setCaretActive();
        return editor;
    }

    @NotNull
    private static Document setupFileEditorAndDocument(@NotNull String fileName, @NotNull String fileText) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance(ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.deleteVFile();
        myVFile = LightPlatformCodeInsightTestCase.getSourceRoot().createChildData(null, fileName);
        VfsUtil.saveText((VirtualFile)myVFile, (String)fileText);
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create document for '" + fileName + "'"), (Object)document);
        manager.reloadFromDisk(document);
        document.insertString(0, (CharSequence)" ");
        document.deleteString(0, 1);
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create PsiFile for '" + fileName + "'. Unknown file type most probably."), (Object)myFile);
        LightPlatformCodeInsightTestCase.assertTrue((boolean)myFile.isPhysical());
        myEditor = LightPlatformCodeInsightTestCase.createEditor(myVFile);
        myVFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        return document2;
    }

    private static void setupEditorForInjectedLanguage() {
        if (myEditor != null) {
            final Ref editorWindowRef = new Ref();
            myEditor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(myEditor, myFile);
                    if (caret == myEditor.getCaretModel().getPrimaryCaret() && editor instanceof EditorWindow) {
                        editorWindowRef.set((Object)((EditorWindow)editor));
                    }
                }
            });
            if (!editorWindowRef.isNull()) {
                myEditor = (Editor)editorWindowRef.get();
                myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
            }
        }
    }

    private static void deleteVFile() throws IOException {
        if (myVFile != null) {
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                public Void compute() throws IOException {
                    myVFile.delete((Object)this);
                    return null;
                }
            });
        }
    }

    @Override
    protected void tearDown() throws Exception {
        VirtualFile[] openFiles;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        LightPlatformCodeInsightTestCase.deleteVFile();
        myEditor = null;
        myFile = null;
        myVFile = null;
        super.tearDown();
    }

    protected void checkResultByFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        this.checkResultByFile(null, filePath, false);
    }

    protected void checkResultByFile(@Nullable String message, @NotNull String filePath, boolean ignoreTrailingSpaces) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        ((PostprocessReformattingAspect)LightPlatformCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = myEditor;
            TrailingSpacesStripper.stripIfNotCurrentLine(editor.getDocument(), false);
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        String fileText = null;
        try {
            fileText = FileUtil.loadFile((File)ioFile, (String)"UTF-8");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + filePath);
    }

    protected void checkResultByText(@NonNls @NotNull String fileText) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(null, fileText, false, null);
    }

    protected void checkResultByText(String message, @NotNull String fileText, boolean ignoreTrailingSpaces) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(message, fileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(final String message, final @NotNull String fileText, final boolean ignoreTrailingSpaces, final String filePath) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
                if (ignoreTrailingSpaces) {
                    ((DocumentImpl)document).stripTrailingSpaces(LightPlatformTestCase.getProject());
                }
                EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document);
                PostprocessReformattingAspect.getInstance(LightPlatformTestCase.getProject()).doPostponedFormatting();
                String newFileText = document.getText();
                PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
                String fileText2 = myFile.getText();
                String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
                if (filePath != null && !newFileText.equals(fileText2)) {
                    throw new FileComparisonFailure(failMessage, newFileText, fileText2, filePath);
                }
                TestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText2);
                EditorTestUtil.verifyCaretAndSelectionState(myEditor, carets, message);
            }
        });
    }

    private static String getMessage(@NonNls String engineMessage, String userMessage) {
        if (userMessage == null) {
            return engineMessage;
        }
        return userMessage + " [" + engineMessage + "]";
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected void caretUp() {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler action = actionManager.getActionHandler("EditorUp");
        action.execute(LightPlatformCodeInsightTestCase.getEditor(), DataManager.getInstance().getDataContext());
    }

    protected void deleteLine() {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler action = actionManager.getActionHandler("EditorDeleteLine");
        action.execute(LightPlatformCodeInsightTestCase.getEditor(), DataManager.getInstance().getDataContext());
    }

    protected static void type(char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        DataContext dataContext = DataManager.getInstance().getDataContext();
        if (c == '\n') {
            actionManager.getActionHandler("EditorEnter").execute(LightPlatformCodeInsightTestCase.getEditor(), dataContext);
        } else if (c == '\b') {
            actionManager.getActionHandler("EditorBackSpace").execute(LightPlatformCodeInsightTestCase.getEditor(), dataContext);
        } else {
            actionManager.getTypedAction().actionPerformed(InjectedLanguageUtil.getTopLevelEditor(LightPlatformCodeInsightTestCase.getEditor()), c, dataContext);
        }
    }

    protected static void type(@NonNls String s) {
        for (char c : s.toCharArray()) {
            LightPlatformCodeInsightTestCase.type(c);
        }
    }

    protected static void backspace() {
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace");
    }

    protected static void delete() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete");
    }

    protected static void home() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStart");
    }

    protected static void end() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEnd");
    }

    protected static void copy() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCopy");
    }

    protected static void paste() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPaste");
    }

    protected static void moveCaretToPreviousWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWordWithSelection");
    }

    protected static void moveCaretToNextWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWordWithSelection");
    }

    protected static void cutLineBackward() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineBackward");
    }

    protected static void cutToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineEnd");
    }

    protected static void deleteToLineStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineStart");
    }

    protected static void deleteToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineEnd");
    }

    protected static void killToWordStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordStart");
    }

    protected static void killToWordEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordEnd");
    }

    protected static void killRegion() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRegion");
    }

    protected static void killRingSave() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRingSave");
    }

    protected static void unindent() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUnindentSelection");
    }

    protected static void selectLine() {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectLine");
    }

    protected static void lineComment() {
        new CommentByLineCommentAction().actionPerformedImpl(LightPlatformCodeInsightTestCase.getProject(), LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(final @NonNls @NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        CommandProcessor.getInstance().executeCommand(LightPlatformCodeInsightTestCase.getProject(), new Runnable(){

            @Override
            public void run() {
                EditorTestUtil.executeAction(LightPlatformCodeInsightTestCase.getEditor(), actionId);
            }
        }, "", null);
    }

    protected static DataContext getCurrentEditorDataContext() {
        final DataContext defaultContext = DataManager.getInstance().getDataContext();
        return new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.EDITOR.is(dataId)) {
                    return LightPlatformCodeInsightTestCase.getEditor();
                }
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return LightPlatformTestCase.getProject();
                }
                if (CommonDataKeys.PSI_FILE.is(dataId)) {
                    return LightPlatformCodeInsightTestCase.getFile();
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    PsiFile file = LightPlatformCodeInsightTestCase.getFile();
                    if (file == null) {
                        return null;
                    }
                    Editor editor = LightPlatformCodeInsightTestCase.getEditor();
                    if (editor == null) {
                        return null;
                    }
                    return file.findElementAt(editor.getCaretModel().getOffset());
                }
                return defaultContext.getData(dataId);
            }
        };
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() throws Throwable {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(Class<?> klass) throws Throwable {
        LightPlatformCodeInsightTestCase testCase = (LightPlatformCodeInsightTestCase)((Object)klass.newInstance());
        if (!(testCase instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)((Object)testCase);
        String testDataPath = testCase.getTestDataPath();
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File(testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart((String)StringUtil.trimStart((String)annotation.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String lastPathComponent = new File(testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = testDataPath.replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File(testDataPath);
            }
        }
        File[] files = testDir.listFiles();
        if (files == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (File file : files) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file.getName());
            if (fileSuffix == null) continue;
            result.add(new Object[]{fileSuffix, testDataPath});
        }
        return result;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    @Before
    public void before() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    LightPlatformCodeInsightTestCase.this.setUp();
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    @After
    public void after() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    LightPlatformCodeInsightTestCase.this.tearDown();
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected void runSingleTest(final Runnable testRunnable) throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    testRunnable.run();
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }
}

