/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtil;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ReferenceEditorComboWithBrowseButton
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    public ReferenceEditorComboWithBrowseButton(ActionListener browseActionListener, String text, @NotNull Project project, boolean toAcceptClasses, String recentsKey) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/ReferenceEditorComboWithBrowseButton", "<init>"));
        }
        this(browseActionListener, text, project, toAcceptClasses, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, recentsKey);
    }

    public ReferenceEditorComboWithBrowseButton(ActionListener browseActionListener, String text, @NotNull Project project, boolean toAcceptClasses, JavaCodeFragment.VisibilityChecker visibilityChecker, String recentsKey) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/ReferenceEditorComboWithBrowseButton", "<init>"));
        }
        super((JComponent)new EditorComboBox(JavaReferenceEditorUtil.createDocument(StringUtil.isEmpty((String)text) ? "" : text, project, toAcceptClasses, visibilityChecker), project, (FileType)StdFileTypes.JAVA), browseActionListener);
        List<String> recentEntries = RecentsManager.getInstance(project).getRecentEntries(recentsKey);
        if (recentEntries != null) {
            this.setHistory(ArrayUtil.toStringArray(recentEntries));
        }
        if (text != null && text.length() > 0) {
            this.prependItem(text);
        }
    }

    public String getText() {
        return ((EditorComboBox)this.getChildComponent()).getText().trim();
    }

    public void setText(String text) {
        ((EditorComboBox)this.getChildComponent()).setText(text);
    }

    public boolean isEditable() {
        return !((EditorComboBox)this.getChildComponent()).getEditorEx().isViewer();
    }

    public void setHistory(String[] history) {
        ((EditorComboBox)this.getChildComponent()).setHistory(history);
    }

    public void prependItem(String item) {
        ((EditorComboBox)this.getChildComponent()).prependItem(item);
    }

    public void appendItem(String item) {
        ((EditorComboBox)this.getChildComponent()).appendItem(item);
    }
}

