/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;

public class ResizeComponentListener
extends MouseAdapter
implements MouseMotionListener,
Weighted {
    private static final int SENSITIVITY = 4;
    private final AbstractPopup myPopup;
    private final AbstractPopup.MyContentPanel myComponent;
    private Point myStartPoint = null;
    @JdkConstants.CursorType
    private int myDirection = -1;
    private final IdeGlassPane myGlassPane;

    public ResizeComponentListener(AbstractPopup popup, IdeGlassPane glassPane) {
        this.myPopup = popup;
        this.myComponent = (AbstractPopup.MyContentPanel)popup.getContent();
        this.myGlassPane = glassPane;
    }

    public double getWeight() {
        return 0.5;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        if (popupWindow != null) {
            this.myStartPoint = new RelativePoint(e).getScreenPoint();
            this.myDirection = this.getDirection(this.myStartPoint, popupWindow.getBounds());
            if (this.myDirection == 0) {
                this.myStartPoint = null;
            } else if (this.isToShowBorder()) {
                this.myComponent.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black.brighter()));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.endOperation();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.endOperation();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        if (popupWindow == null) {
            return;
        }
        this.clearBorder(popupWindow);
    }

    private void endOperation() {
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        if (popupWindow != null) {
            if (this.isToShowBorder()) {
                this.myComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            Dimension size = popupWindow.getSize();
            Dimension minSize = popupWindow.getMinimumSize();
            if (size.width < minSize.width) {
                size.width = minSize.width;
            }
            if (size.height < minSize.height) {
                size.height = minSize.height;
            }
            popupWindow.setSize(size);
            popupWindow.validate();
            popupWindow.repaint();
            this.setWindowCursor(0);
            this.myPopup.storeDimensionSize(popupWindow.getSize());
        }
        this.myStartPoint = null;
        this.myDirection = -1;
    }

    private boolean isToShowBorder() {
        return false;
    }

    private void doResize(Point point) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        Rectangle bounds = popupWindow.getBounds();
        Point location = popupWindow.getLocation();
        switch (this.myDirection) {
            case 6: {
                popupWindow.setBounds(location.x + point.x - this.myStartPoint.x, location.y + point.y - this.myStartPoint.y, bounds.width + this.myStartPoint.x - point.x, bounds.height + this.myStartPoint.y - point.y);
                break;
            }
            case 8: {
                popupWindow.setBounds(location.x, location.y + point.y - this.myStartPoint.y, bounds.width, bounds.height + this.myStartPoint.y - point.y);
                break;
            }
            case 7: {
                popupWindow.setBounds(location.x, location.y + point.y - this.myStartPoint.y, bounds.width + point.x - this.myStartPoint.x, bounds.height + this.myStartPoint.y - point.y);
                break;
            }
            case 11: {
                popupWindow.setBounds(location.x, location.y, bounds.width + point.x - this.myStartPoint.x, bounds.height);
                break;
            }
            case 5: {
                popupWindow.setBounds(location.x, location.y, bounds.width + point.x - this.myStartPoint.x, bounds.height + point.y - this.myStartPoint.y);
                break;
            }
            case 9: {
                popupWindow.setBounds(location.x, location.y, bounds.width, bounds.height + point.y - this.myStartPoint.y);
                break;
            }
            case 4: {
                popupWindow.setBounds(location.x + point.x - this.myStartPoint.x, location.y, bounds.width + this.myStartPoint.x - point.x, bounds.height + point.y - this.myStartPoint.y);
                break;
            }
            case 10: {
                popupWindow.setBounds(location.x + point.x - this.myStartPoint.x, location.y, bounds.width + this.myStartPoint.x - point.x, bounds.height);
            }
        }
        popupWindow.validate();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point point = new RelativePoint(e).getScreenPoint();
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        if (popupWindow == null) {
            return;
        }
        int cursor = this.getDirection(point, popupWindow.getBounds());
        if (cursor != 0) {
            if (this.isToShowBorder() && this.myStartPoint == null) {
                this.myComponent.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black.brighter()));
            }
            this.setWindowCursor(cursor);
            e.consume();
        } else {
            this.clearBorder(popupWindow);
        }
    }

    private void setWindowCursor(@JdkConstants.CursorType int cursor) {
        this.myGlassPane.setCursor(Cursor.getPredefinedCursor(cursor), (Object)this);
    }

    private void clearBorder(Window popupWindow) {
        if (this.isToShowBorder()) {
            this.myComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        this.setWindowCursor(0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Point point = new RelativePoint(e).getScreenPoint();
        Window popupWindow = SwingUtilities.windowForComponent(this.myComponent);
        if (popupWindow == null) {
            return;
        }
        if (this.myStartPoint != null) {
            if (this.isToShowBorder()) {
                this.setWindowCursor(this.myDirection);
            }
            this.doResize(point);
            this.myStartPoint = point;
            e.consume();
        } else if (this.isToShowBorder()) {
            int cursor = this.getDirection(point, popupWindow.getBounds());
            this.setWindowCursor(cursor);
        }
    }

    @JdkConstants.CursorType
    private int getDirection(Point startPoint, Rectangle bounds) {
        if (this.myPopup.isToDrawMacCorner() && bounds.x + bounds.width - startPoint.x < 16 && bounds.y + bounds.height - startPoint.y < 16 && bounds.y + bounds.height - startPoint.y > 0 && bounds.x + bounds.width - startPoint.x > 0) {
            return 5;
        }
        bounds = new Rectangle(bounds.x + 2, bounds.y + 2, bounds.width - 2, bounds.height - 2);
        if (!bounds.contains(startPoint)) {
            return 0;
        }
        if (Math.abs(startPoint.x - bounds.x) < 4) {
            if (Math.abs(startPoint.y - bounds.y) < 4) {
                return 6;
            }
            if (Math.abs(bounds.y + bounds.height - startPoint.y) < 4) {
                return 4;
            }
            return 10;
        }
        if (Math.abs(bounds.x + bounds.width - startPoint.x) < 4) {
            if (Math.abs(startPoint.y - bounds.y) < 4) {
                return 7;
            }
            if (Math.abs(bounds.y + bounds.height - startPoint.y) < 4) {
                return 5;
            }
            return 11;
        }
        if (Math.abs(startPoint.y - bounds.y) < 4) {
            return 8;
        }
        if (Math.abs(bounds.y + bounds.height - startPoint.y) < 4) {
            return 9;
        }
        return 0;
    }
}

