/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.TextFieldWithAutoCompletionContributor;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithAutoCompletion<T>
extends LanguageTextField {
    public static final TextFieldWithAutoCompletionListProvider EMPTY_COMPLETION = new StringsCompletionProvider(null, null);
    private final boolean myShowAutocompletionIsAvailableHint;
    private final TextFieldWithAutoCompletionListProvider<T> myProvider;

    public TextFieldWithAutoCompletion() {
        this(null, EMPTY_COMPLETION, false, null);
    }

    public TextFieldWithAutoCompletion(Project project, @NotNull TextFieldWithAutoCompletionListProvider<T> provider, boolean showAutocompletionIsAvailableHint, @Nullable String text) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/TextFieldWithAutoCompletion", "<init>"));
        }
        super(project == null ? null : PlainTextLanguage.INSTANCE, project, text == null ? "" : text);
        this.myShowAutocompletionIsAvailableHint = showAutocompletionIsAvailableHint;
        this.myProvider = provider;
        TextFieldWithAutoCompletionContributor.installCompletion(this.getDocument(), project, provider, true);
    }

    public static TextFieldWithAutoCompletion<String> create(Project project, @NotNull Collection<String> items, boolean showAutocompletionIsAvailableHint, @Nullable String text) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        return TextFieldWithAutoCompletion.create(project, items, null, showAutocompletionIsAvailableHint, text);
    }

    public static TextFieldWithAutoCompletion<String> create(Project project, @NotNull Collection<String> items, @Nullable Icon icon, boolean showAutocompletionIsAvailableHint, @Nullable String text) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        return new TextFieldWithAutoCompletion<String>(project, new StringsCompletionProvider(items, icon), showAutocompletionIsAvailableHint, text);
    }

    public void setVariants(@NotNull Collection<T> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/ui/TextFieldWithAutoCompletion", "setVariants"));
        }
        this.myProvider.setItems(variants);
    }

    public <T> void installProvider(@NotNull TextFieldWithAutoCompletionListProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/TextFieldWithAutoCompletion", "installProvider"));
        }
        TextFieldWithAutoCompletionContributor.installCompletion(this.getDocument(), this.getProject(), provider, true);
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        if (!this.myShowAutocompletionIsAvailableHint) {
            return editor;
        }
        final String completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        if (StringUtil.isEmpty((String)completionShortcutText)) {
            return editor;
        }
        final Ref toShowHintRef = new Ref((Object)true);
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                toShowHintRef.set((Object)false);
            }
        });
        editor.addFocusListener(new FocusChangeListener(){

            @Override
            public void focusGained(final Editor editor) {
                if (((Boolean)toShowHintRef.get()).booleanValue() && TextFieldWithAutoCompletion.this.getText().length() == 0) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HintManager.getInstance().showInformationHint(editor, "Code completion available ( " + completionShortcutText + " )");
                        }
                    });
                }
            }

            @Override
            public void focusLost(Editor editor) {
            }
        });
        return editor;
    }

    public static class StringsCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String>
    implements DumbAware {
        @Nullable
        private final Icon myIcon;

        public StringsCompletionProvider(@Nullable Collection<String> variants, @Nullable Icon icon) {
            super(variants);
            this.myIcon = icon;
        }

        @Override
        public int compare(String item1, String item2) {
            return StringUtil.compare((String)item1, (String)item2, (boolean)false);
        }

        @Override
        protected Icon getIcon(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getIcon"));
            }
            return this.myIcon;
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getLookupString"));
            }
            String string = item;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Override
        protected String getTailText(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getTailText"));
            }
            return null;
        }

        @Override
        protected String getTypeText(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getTypeText"));
            }
            return null;
        }
    }
}

