/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.actions.GraphMouseAction;
import com.intellij.vcs.log.graph.api.LinearGraphWithCommitInfo;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.visible.CurrentBranches;
import com.intellij.vcs.log.graph.impl.visible.adapters.LinearGraphAsGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.utils.Flags;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVisibleGraph<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    protected final GraphAnswerImpl<CommitId> COMMIT_ID_GRAPH_ANSWER;
    @NotNull
    protected final LinearGraphWithCommitInfo<CommitId> myLinearGraphWithCommitInfo;
    @NotNull
    protected final PrintElementGenerator myPrintElementGenerator;
    @NotNull
    protected final PrintElementsManager myPrintElementsManager;
    @NotNull
    protected final Map<CommitId, GraphCommit<CommitId>> myCommitsWithNotLoadParent;

    @NotNull
    protected static <CommitId> LinearGraphAsGraphWithHiddenNodes createBranchesGraph(@NotNull PermanentGraphInfo<CommitId> permanentGraph, @Nullable Set<CommitId> heads) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "createBranchesGraph"));
        }
        if (heads == null) {
            LinearGraphAsGraphWithHiddenNodes linearGraphAsGraphWithHiddenNodes = new LinearGraphAsGraphWithHiddenNodes(permanentGraph.getPermanentLinearGraph());
            if (linearGraphAsGraphWithHiddenNodes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "createBranchesGraph"));
            }
            return linearGraphAsGraphWithHiddenNodes;
        }
        Set<Integer> headIndexes = permanentGraph.getPermanentCommitsInfo().convertToCommitIndexes(heads);
        if (headIndexes.contains(-1)) {
            throw new IllegalStateException();
        }
        Flags visibleNodes = CurrentBranches.getVisibleNodes(permanentGraph.getPermanentLinearGraph(), headIndexes);
        LinearGraphAsGraphWithHiddenNodes linearGraphAsGraphWithHiddenNodes = new LinearGraphAsGraphWithHiddenNodes(permanentGraph.getPermanentLinearGraph(), visibleNodes);
        if (linearGraphAsGraphWithHiddenNodes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "createBranchesGraph"));
        }
        return linearGraphAsGraphWithHiddenNodes;
    }

    protected AbstractVisibleGraph(@NotNull LinearGraphWithCommitInfo<CommitId> linearGraphWithCommitInfo, @NotNull Map<CommitId, GraphCommit<CommitId>> commitsWithNotLoadParent, @NotNull PrintElementsManager printElementsManager) {
        if (linearGraphWithCommitInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraphWithCommitInfo", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "<init>"));
        }
        if (commitsWithNotLoadParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsWithNotLoadParent", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "<init>"));
        }
        this.COMMIT_ID_GRAPH_ANSWER = new GraphAnswerImpl<Object>(null, Cursor.getDefaultCursor());
        this.myLinearGraphWithCommitInfo = linearGraphWithCommitInfo;
        this.myCommitsWithNotLoadParent = commitsWithNotLoadParent;
        this.myPrintElementsManager = printElementsManager;
        this.myPrintElementGenerator = new PrintElementGeneratorImpl(linearGraphWithCommitInfo, printElementsManager);
    }

    public int getVisibleCommitCount() {
        return this.myLinearGraphWithCommitInfo.nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(final int visibleRow) {
        if (visibleRow < 0 || visibleRow >= this.getVisibleCommitCount()) {
            throw new IndexOutOfBoundsException("VisibleCommitCount is: " + this.getVisibleCommitCount() + ", but visibleRow: " + visibleRow);
        }
        RowInfo rowInfo = new RowInfo<CommitId>(){

            @NotNull
            public CommitId getCommit() {
                Object CommitId = AbstractVisibleGraph.this.myLinearGraphWithCommitInfo.getHashIndex(visibleRow);
                if (CommitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$1", "getCommit"));
                }
                return CommitId;
            }

            @NotNull
            public CommitId getOneOfHeads() {
                Object CommitId = AbstractVisibleGraph.this.myLinearGraphWithCommitInfo.getOneOfHeads(visibleRow);
                if (CommitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$1", "getOneOfHeads"));
                }
                return CommitId;
            }

            @NotNull
            public Collection<PrintElement> getPrintElements() {
                Collection<PrintElement> collection = AbstractVisibleGraph.this.myPrintElementGenerator.getPrintElements(visibleRow);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$1", "getPrintElements"));
                }
                return collection;
            }

            @NotNull
            public RowType getRowType() {
                RowType rowType = RowType.NORMAL;
                if (rowType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$1", "getRowType"));
                }
                return rowType;
            }
        };
        if (rowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "getRowInfo"));
        }
        return rowInfo;
    }

    public int getVisibleRowIndex(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "getVisibleRowIndex"));
        }
        return this.myLinearGraphWithCommitInfo.getNodeIndex(commitId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        ActionControllerImpl actionControllerImpl = new ActionControllerImpl();
        if (actionControllerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "getActionController"));
        }
        return actionControllerImpl;
    }

    protected abstract void setLinearBranchesExpansion(boolean var1);

    @NotNull
    protected abstract GraphAnswer<CommitId> clickByElement(@NotNull GraphElement var1);

    @NotNull
    protected GraphAnswer<CommitId> clickByElement(@Nullable PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            GraphAnswerImpl<CommitId> graphAnswerImpl = this.COMMIT_ID_GRAPH_ANSWER;
            if (graphAnswerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
            }
            return graphAnswerImpl;
        }
        if (printElement instanceof SimplePrintElement) {
            SimplePrintElement simplePrintElement = (SimplePrintElement)printElement;
            GraphElement graphElement = printElement.getGraphElement();
            switch (simplePrintElement.getType()) {
                case NODE: {
                    assert (graphElement instanceof GraphNode);
                    GraphAnswer<CommitId> graphAnswer = this.clickByElement(graphElement);
                    if (graphAnswer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
                    }
                    return graphAnswer;
                }
                case UP_ARROW: {
                    assert (graphElement instanceof GraphEdge);
                    int upNodeIndex = ((GraphEdge)graphElement).getUpNodeIndex();
                    GraphAnswer<CommitId> graphAnswer = this.createJumpAnswer(upNodeIndex);
                    if (graphAnswer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
                    }
                    return graphAnswer;
                }
                case DOWN_ARROW: {
                    assert (graphElement instanceof GraphEdge);
                    int downNodeIndex = ((GraphEdge)graphElement).getDownNodeIndex();
                    if (downNodeIndex != Integer.MAX_VALUE) {
                        GraphAnswer<CommitId> graphAnswer = this.createJumpAnswer(downNodeIndex);
                        if (graphAnswer == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
                        }
                        return graphAnswer;
                    }
                    int upNodeIndex = ((GraphEdge)graphElement).getUpNodeIndex();
                    int edgeIndex = this.myLinearGraphWithCommitInfo.getDownNodes(upNodeIndex).indexOf(Integer.MAX_VALUE);
                    GraphCommit<CommitId> commitIdGraphCommit = this.myCommitsWithNotLoadParent.get(this.myLinearGraphWithCommitInfo.getHashIndex(upNodeIndex));
                    Object jumpTo = commitIdGraphCommit.getParents().get(edgeIndex);
                    GraphAnswerImpl graphAnswerImpl = this.createJumpAnswer(jumpTo);
                    if (graphAnswerImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
                    }
                    return graphAnswerImpl;
                }
            }
            throw new IllegalStateException("Unsupported SimplePrintElement type: " + simplePrintElement.getType());
        }
        if (printElement instanceof EdgePrintElement) {
            GraphElement graphElement = printElement.getGraphElement();
            assert (graphElement instanceof GraphEdge);
            GraphAnswer<CommitId> graphAnswer = this.clickByElement(graphElement);
            if (graphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
            }
            return graphAnswer;
        }
        GraphAnswerImpl<CommitId> graphAnswerImpl = this.COMMIT_ID_GRAPH_ANSWER;
        if (graphAnswerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph", "clickByElement"));
        }
        return graphAnswerImpl;
    }

    protected GraphAnswer<CommitId> createJumpAnswer(int nodeIndex) {
        return this.createJumpAnswer(this.myLinearGraphWithCommitInfo.getHashIndex(nodeIndex));
    }

    private GraphAnswerImpl<CommitId> createJumpAnswer(CommitId commitId) {
        this.myPrintElementGenerator.invalidate();
        return new GraphAnswerImpl<CommitId>(commitId, null);
    }

    protected class ActionControllerImpl
    implements ActionController<CommitId> {
        protected ActionControllerImpl() {
        }

        @NotNull
        public GraphAnswer<CommitId> performMouseAction(@NotNull GraphMouseAction graphMouseAction) {
            if (graphMouseAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphMouseAction", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$ActionControllerImpl", "performMouseAction"));
            }
            PrintElementWithGraphElement printElement = this.getPrintElementWithGraphElement(graphMouseAction);
            switch (graphMouseAction.getType()) {
                case OVER: {
                    Cursor cursor = AbstractVisibleGraph.this.myPrintElementsManager.performOverElement(printElement);
                    GraphAnswerImpl<Object> graphAnswerImpl = new GraphAnswerImpl<Object>(null, cursor);
                    if (graphAnswerImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$ActionControllerImpl", "performMouseAction"));
                    }
                    return graphAnswerImpl;
                }
                case CLICK: {
                    AbstractVisibleGraph.this.myPrintElementsManager.performOverElement(printElement);
                    GraphAnswer graphAnswer = AbstractVisibleGraph.this.clickByElement(printElement);
                    if (graphAnswer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$ActionControllerImpl", "performMouseAction"));
                    }
                    return graphAnswer;
                }
            }
            throw new IllegalStateException("Not supported GraphMouseAction type: " + graphMouseAction.getType());
        }

        @Nullable
        private PrintElementWithGraphElement getPrintElementWithGraphElement(@NotNull GraphMouseAction graphMouseAction) {
            if (graphMouseAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphMouseAction", "com/intellij/vcs/log/graph/impl/facade/AbstractVisibleGraph$ActionControllerImpl", "getPrintElementWithGraphElement"));
            }
            PrintElement affectedElement = graphMouseAction.getAffectedElement();
            if (affectedElement == null) {
                return null;
            }
            return AbstractVisibleGraph.this.myPrintElementGenerator.toPrintElementWithGraphElement(affectedElement);
        }

        public boolean areLongEdgesHidden() {
            return AbstractVisibleGraph.this.myPrintElementGenerator.areLongEdgesHidden();
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            AbstractVisibleGraph.this.myPrintElementGenerator.setLongEdgesHidden(longEdgesHidden);
        }

        public void setLinearBranchesExpansion(boolean collapse) {
            AbstractVisibleGraph.this.setLinearBranchesExpansion(collapse);
            AbstractVisibleGraph.this.myPrintElementGenerator.invalidate();
        }
    }

    protected static class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final CommitId myCommitId;
        @Nullable
        private final Cursor myCursor;

        public GraphAnswerImpl(@Nullable CommitId commitId, @Nullable Cursor cursor) {
            this.myCommitId = commitId;
            this.myCursor = cursor;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.myCursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.myCommitId;
        }
    }
}

