/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    private static final int SHORT_FRAGMENT_MAX_SIZE = 10;
    private static final int MAX_SEARCH_SIZE = 10;
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final Condition<Integer> myThisNodeCantBeInMiddle;
    private final Function<Integer, List<Integer>> upNodesFun;
    private final Function<Integer, List<Integer>> downNodesFun;

    public FragmentGenerator(@NotNull LinearGraph linearGraph, @NotNull Condition<Integer> thisNodeCantBeInMiddle) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/visible/FragmentGenerator", "<init>"));
        }
        if (thisNodeCantBeInMiddle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisNodeCantBeInMiddle", "com/intellij/vcs/log/graph/impl/visible/FragmentGenerator", "<init>"));
        }
        this.upNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return FragmentGenerator.this.myLinearGraph.getUpNodes(integer);
            }
        };
        this.downNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return FragmentGenerator.this.myLinearGraph.getDownNodes(integer);
            }
        };
        this.myLinearGraph = linearGraph;
        this.myThisNodeCantBeInMiddle = thisNodeCantBeInMiddle;
    }

    @Nullable
    public GraphFragment getRelativeFragment(@NotNull GraphElement element) {
        int downNodeIndex;
        int upNodeIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/FragmentGenerator", "getRelativeFragment"));
        }
        if (element instanceof GraphNode) {
            downNodeIndex = upNodeIndex = ((GraphNode)element).getNodeIndex();
        } else {
            GraphEdge graphEdge = (GraphEdge)element;
            upNodeIndex = graphEdge.getUpNodeIndex();
            downNodeIndex = graphEdge.getDownNodeIndex();
        }
        for (int i = 0; i < 10; ++i) {
            GraphFragment graphFragment = this.getDownFragment(upNodeIndex);
            if (graphFragment != null && graphFragment.downNodeIndex >= downNodeIndex) {
                return graphFragment;
            }
            List<Integer> upNodes = this.myLinearGraph.getUpNodes(upNodeIndex);
            if (upNodes.size() != 1) break;
            upNodeIndex = upNodes.get(0);
        }
        return null;
    }

    @Nullable
    public GraphFragment getDownFragment(int upperVisibleNodeIndex) {
        Pair<Integer, Integer> fragment = FragmentGenerator.getFragment(upperVisibleNodeIndex, this.downNodesFun, this.upNodesFun, this.myThisNodeCantBeInMiddle);
        return fragment == null ? null : new GraphFragment((Integer)fragment.first, (Integer)fragment.second);
    }

    @Nullable
    public GraphFragment getUpFragment(int lowerNodeIndex) {
        Pair<Integer, Integer> fragment = FragmentGenerator.getFragment(lowerNodeIndex, this.upNodesFun, this.downNodesFun, this.myThisNodeCantBeInMiddle);
        return fragment == null ? null : new GraphFragment((Integer)fragment.second, (Integer)fragment.first);
    }

    @Nullable
    public GraphFragment getLongDownFragment(int rowIndex) {
        return this.getLongFragment(this.getDownFragment(rowIndex), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/FragmentGenerator", "getLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getPartLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/visible/FragmentGenerator", "getPartLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), 500);
    }

    @Nullable
    private GraphFragment getLongFragment(@Nullable GraphFragment startFragment, int bound) {
        GraphFragment shortFragment;
        if (startFragment == null) {
            return null;
        }
        int maxDown = startFragment.downNodeIndex;
        while ((shortFragment = this.getDownFragment(maxDown)) != null && !this.myThisNodeCantBeInMiddle.value((Object)maxDown) && (maxDown = shortFragment.downNodeIndex) - startFragment.downNodeIndex <= bound) {
        }
        int maxUp = startFragment.upNodeIndex;
        while ((shortFragment = this.getUpFragment(maxUp)) != null && !this.myThisNodeCantBeInMiddle.value((Object)maxUp) && startFragment.upNodeIndex - (maxUp = shortFragment.upNodeIndex) <= bound) {
        }
        if (maxUp != startFragment.upNodeIndex || maxDown != startFragment.downNodeIndex) {
            return new GraphFragment(maxUp, maxDown);
        }
        if (this.myLinearGraph.getDownNodes(startFragment.upNodeIndex).size() != 1) {
            return startFragment;
        }
        return null;
    }

    @Nullable
    private static Pair<Integer, Integer> getFragment(int startNode, Function<Integer, List<Integer>> getNextNodes, Function<Integer, List<Integer>> getPrevNodes, Condition<Integer> thisNodeCantBeInMiddle) {
        HashSet<Integer> blackNodes = new HashSet<Integer>();
        blackNodes.add(startNode);
        HashSet grayNodes = new HashSet();
        grayNodes.addAll((Collection)getNextNodes.fun((Object)startNode));
        int endNode = -1;
        while (blackNodes.size() < 10 && !grayNodes.contains(Integer.MAX_VALUE)) {
            int nextBlackNode = -1;
            Iterator i$ = grayNodes.iterator();
            while (i$.hasNext()) {
                int grayNode = (Integer)i$.next();
                if (!blackNodes.containsAll((Collection)getPrevNodes.fun((Object)grayNode))) continue;
                nextBlackNode = grayNode;
                break;
            }
            if (nextBlackNode == -1) {
                return null;
            }
            if (grayNodes.size() == 1) {
                endNode = nextBlackNode;
                break;
            }
            List nextGrayNodes = (List)getNextNodes.fun((Object)nextBlackNode);
            if (nextGrayNodes.isEmpty() || thisNodeCantBeInMiddle.value((Object)nextBlackNode)) {
                return null;
            }
            blackNodes.add(nextBlackNode);
            grayNodes.remove(nextBlackNode);
            grayNodes.addAll(nextGrayNodes);
        }
        if (endNode != -1) {
            return Pair.create((Object)startNode, (Object)endNode);
        }
        return null;
    }

    public static class GraphFragment {
        public final int upNodeIndex;
        public final int downNodeIndex;

        public GraphFragment(int upNodeIndex, int downNodeIndex) {
            this.upNodeIndex = upNodeIndex;
            this.downNodeIndex = downNodeIndex;
        }
    }
}

