/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XVariablesView
extends XVariablesViewBase {
    public static final Key<Map<Pair<VirtualFile, Integer>, Set<XValueNodeImpl>>> DEBUG_VARIABLES = Key.create((String)"debug.variables");
    public static final Key<Map<VirtualFile, Long>> DEBUG_VARIABLES_TIMESTAMPS = Key.create((String)"debug.variables.timestamps");

    public XVariablesView(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XVariablesView", "<init>"));
        }
        super(session.getProject(), session.getDebugProcess().getEditorsProvider(), session.getValueMarkers());
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XVariablesView", "processSessionEvent"));
        }
        XDebugSession session = XVariablesView.getSession(this.getPanel());
        XStackFrame stackFrame = session == null ? null : session.getCurrentStackFrame();
        XDebuggerTree tree = this.getTree();
        if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
            this.saveCurrentTreeState(stackFrame);
            if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        tree.markNodesObsolete();
        if (stackFrame != null) {
            this.cancelClear();
            this.buildTreeAndRestoreState(stackFrame);
        } else {
            this.requestClear();
        }
    }

    @Override
    protected void clear() {
        MessageTreeNode node;
        XDebuggerTree tree = this.getTree();
        tree.getProject().putUserData(DEBUG_VARIABLES, null);
        tree.getProject().putUserData(DEBUG_VARIABLES_TIMESTAMPS, null);
        tree.setSourcePosition(null);
        XDebugSession session = XVariablesView.getSession(this.getPanel());
        if (session == null || !session.isStopped() && session.isPaused()) {
            node = MessageTreeNode.createInfoMessage(tree, "Frame is not available");
        } else {
            XDebugProcess debugProcess = session.getDebugProcess();
            node = MessageTreeNode.createInfoMessage(tree, debugProcess.getCurrentStateMessage(), debugProcess.getCurrentStateHyperlinkListener());
        }
        tree.setRoot(node, true);
    }
}

