/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class XsdNamespaceBuilder
extends NanoXmlUtil.IXMLBuilderAdapter
implements Comparable<XsdNamespaceBuilder> {
    private String myCurrentTag;
    private int myCurrentDepth;
    private String myNamespace;
    private String myVersion;
    private List<String> myTags = new ArrayList<String>();
    private final List<String> myAttributes = new ArrayList<String>();

    public static String computeNamespace(InputStream is) {
        return XsdNamespaceBuilder.computeNamespace(new InputStreamReader(is)).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XsdNamespaceBuilder computeNamespace(Reader reader) {
        try {
            XsdNamespaceBuilder builder = new XsdNamespaceBuilder();
            NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder);
            XsdNamespaceBuilder xsdNamespaceBuilder = builder;
            return xsdNamespaceBuilder;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void startElement(@NonNls String name, @NonNls String nsPrefix, @NonNls String nsURI, String systemID, int lineNr) throws Exception {
        if (this.myCurrentDepth < 2 && "http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
            this.myCurrentTag = name;
        }
        ++this.myCurrentDepth;
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        --this.myCurrentDepth;
        this.myCurrentTag = null;
    }

    public void addAttribute(@NonNls String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        if ("schema".equals(this.myCurrentTag)) {
            if ("targetNamespace".equals(key)) {
                this.myNamespace = value;
            } else if ("version".equals(key)) {
                this.myVersion = value;
            }
        } else if ("element".equals(this.myCurrentTag) && "name".equals(key)) {
            this.myTags.add(value);
        }
    }

    @Override
    public int compareTo(XsdNamespaceBuilder o) {
        return Comparing.compare((Comparable)((Object)this.myNamespace), (Comparable)((Object)o.myNamespace));
    }

    public int getRating(@Nullable String tagName, @Nullable String version) {
        int rate = 0;
        if (tagName != null && this.myTags.contains(tagName)) {
            rate |= 2;
        }
        if (version != null && version.equals(this.myVersion)) {
            rate |= 1;
        }
        return rate;
    }

    private XsdNamespaceBuilder() {
    }

    public XsdNamespaceBuilder(String namespace, String version, List<String> tags) {
        this.myNamespace = namespace;
        this.myVersion = version;
        this.myTags = tags;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<String> getTags() {
        return this.myTags;
    }

    public List<String> getAttributes() {
        return this.myAttributes;
    }
}

