/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssignmentToSuperclassFieldInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.superclass.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToSuperclassFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        PsiClass superclass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.to.superclass.field.problem.descriptor", referenceExpression.getReferenceName(), superclass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToSuperclassFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToSuperclassFieldVisitor();
    }

    private static class AssignmentToSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private AssignmentToSuperclassFieldVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            this.checkSuperclassField(lhs);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            PsiExpression operand = expression.getOperand();
            this.checkSuperclassField(operand);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            PsiExpression operand = expression.getOperand();
            this.checkSuperclassField(operand);
        }

        private void checkSuperclassField(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (method == null || !method.isConstructor()) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression) && !(qualifierExpression instanceof PsiSuperExpression)) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiClass assignmentClass = method.getContainingClass();
            String name = fieldClass.getQualifiedName();
            if (name == null || !InheritanceUtil.isInheritor((PsiClass)assignmentClass, (boolean)true, (String)name)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression, fieldClass);
        }
    }
}

