/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassWithOnlyPrivateConstructorsInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.with.only.private.constructors.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassWithOnlyPrivateConstructorsInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.with.only.private.constructors.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassWithOnlyPrivateConstructorsInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithOnlyPrivateConstructorsVisitor();
    }

    private static class ClassWithOnlyPrivateConstructorsVisitor
    extends BaseInspectionVisitor {
        private ClassWithOnlyPrivateConstructorsVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiClass[] innerClasses;
            super.visitClass(aClass);
            if (aClass.isEnum()) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (!ClassWithOnlyPrivateConstructorsVisitor.isExtendedByInnerClass(innerClass, aClass, new HashSet<PsiClass>())) continue;
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static boolean isExtendedByInnerClass(PsiClass innerClass, PsiClass superClass, Set<PsiClass> visited) {
            PsiClass[] innerClasses;
            if (!visited.add(innerClass)) {
                return false;
            }
            if (innerClass.isInheritor(superClass, false)) {
                return true;
            }
            for (PsiClass aClass : innerClasses = innerClass.getInnerClasses()) {
                if (!ClassWithOnlyPrivateConstructorsVisitor.isExtendedByInnerClass(aClass, superClass, visited)) continue;
                return true;
            }
            return false;
        }
    }
}

