/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class InitializationDependencyUtils {
    private static final Key<Set<RefClass>> INITIALIZATION_DEPENDENT_CLASSES_KEY = new Key("INITIALIZATION_DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> INITIALIZATION_DEPENDENCY_CLASSES_KEY = new Key("INITIALIZATION_DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> TRANSITIVE_INITIALIZATION_DEPENDENT_CLASSES_KEY = new Key("TRANSITIVE_INITIALIZATION_DEPENDENT_CLASSES_KEY");
    private static final Key<Set<RefClass>> TRANSITIVE_INITIALIZATION_DEPENDENCY_CLASSES_KEY = new Key("TRANSITIVE_INITIALIZATION_DEPENDENCY_CLASSES_KEY");

    private InitializationDependencyUtils() {
    }

    public static Set<RefClass> calculateInitializationDependenciesForClass(RefClass refClass) {
        Set dependencies = (Set)refClass.getUserData(INITIALIZATION_DEPENDENCY_CLASSES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        InitializationDependencyUtils.tabulateInitializationDependencyClasses((RefElement)refClass, newDependencies);
        newDependencies.remove(refClass);
        refClass.putUserData(INITIALIZATION_DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    static void tabulateInitializationDependencyClasses(RefElement element, Set<RefClass> dependencies) {
        Collection references = element.getOutReferences();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        for (RefElement reference : references) {
            RefClass refClass = refUtil.getTopLevelClass(reference);
            if (refClass == null) continue;
            dependencies.add(refClass);
        }
        List children = element.getChildren();
        if (children == null) {
            return;
        }
        for (RefEntity child : children) {
            if (!(child instanceof RefElement)) continue;
            InitializationDependencyUtils.tabulateInitializationDependencyClasses((RefElement)child, dependencies);
        }
    }

    public static Set<RefClass> calculateTransitiveInitializationDependenciesForClass(RefClass refClass) {
        Set dependencies = (Set)refClass.getUserData(TRANSITIVE_INITIALIZATION_DEPENDENCY_CLASSES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        InitializationDependencyUtils.tabulateTransitiveInitializationDependencyClasses(refClass, newDependencies);
        refClass.putUserData(TRANSITIVE_INITIALIZATION_DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateTransitiveInitializationDependencyClasses(RefClass refClass, Set<RefClass> newDependencies) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        pendingClasses.addLast(refClass);
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependencies.add(classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependencies = InitializationDependencyUtils.calculateInitializationDependenciesForClass(classToProcess);
            for (RefClass dependency : dependencies) {
                if (pendingClasses.contains(dependency) || processedClasses.contains(dependency)) continue;
                pendingClasses.addLast(dependency);
            }
        }
        newDependencies.remove(refClass);
    }

    public static Set<RefClass> calculateInitializationDependentsForClass(RefClass refClass) {
        Set dependents = (Set)refClass.getUserData(INITIALIZATION_DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        InitializationDependencyUtils.tabulateInitializationDependentClasses((RefElement)refClass, newDependents);
        newDependents.remove(refClass);
        refClass.putUserData(INITIALIZATION_DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateInitializationDependentClasses(RefElement element, Set<RefClass> dependents) {
        Collection references = element.getInReferences();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        for (RefElement reference : references) {
            RefClass refClass = refUtil.getTopLevelClass(reference);
            if (refClass == null) continue;
            dependents.add(refClass);
        }
        List children = element.getChildren();
        if (children == null) {
            return;
        }
        for (RefEntity child : children) {
            if (!(child instanceof RefElement)) continue;
            InitializationDependencyUtils.tabulateInitializationDependentClasses((RefElement)child, dependents);
        }
    }

    public static Set<RefClass> calculateTransitiveInitializationDependentsForClass(RefClass refClass) {
        Set dependents = (Set)refClass.getUserData(TRANSITIVE_INITIALIZATION_DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        InitializationDependencyUtils.tabulateInitializationTransitiveDependentClasses(refClass, newDependents);
        refClass.putUserData(TRANSITIVE_INITIALIZATION_DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateInitializationTransitiveDependentClasses(RefClass refClass, Set<RefClass> newDependents) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        pendingClasses.addLast(refClass);
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependents.add(classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependents = InitializationDependencyUtils.calculateInitializationDependentsForClass(classToProcess);
            for (RefClass dependent : dependents) {
                if (pendingClasses.contains(dependent) || processedClasses.contains(dependent)) continue;
                pendingClasses.addLast(dependent);
            }
        }
        newDependents.remove(refClass);
    }
}

