/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

final class ArtifactWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    ArtifactWebServerRootsProvider() {
    }

    @Override
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider", "resolve"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider", "resolve"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider", "resolve"));
        }
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            VirtualFile file;
            VirtualFile root = artifact.getOutputFile();
            if (root == null || (file = root.findFileByRelativePath(path)) == null) continue;
            return new PathInfo(file, root);
        }
        return null;
    }

    @Override
    @Nullable
    public PathInfo getRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider", "getRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider", "getRoot"));
        }
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            VirtualFile root = artifact.getOutputFile();
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
            return new PathInfo(file, root);
        }
        return null;
    }
}

