/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLConnection;
import java.util.Set;

public abstract class DownloadManager {
    private static final ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();
    private final Project myProject;
    private final ProgressIndicator myProgress;
    private final String myResourcePath;

    public DownloadManager(Project project, ProgressIndicator progress) {
        this.myProject = project;
        this.myProgress = progress;
        this.myResourcePath = PathManager.getSystemPath() + File.separatorChar + "extResources";
        File dir = new File(this.myResourcePath);
        dir.mkdirs();
    }

    public void fetch(String location) throws DownloadException {
        if (resourceManager.getResourceLocation(location) == location) {
            this.myProgress.setText("Downloading " + location);
            this.downloadAndRegister(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndRegister(final String location) throws DownloadException {
        block23: {
            final ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();
            File file = null;
            try {
                URLConnection urlConnection = HttpConfigurable.getInstance().openConnection(location);
                urlConnection.connect();
                InputStream in = urlConnection.getInputStream();
                try {
                    int total = urlConnection.getContentLength();
                    String name = Integer.toHexString(System.identityHashCode(this)) + "_" + Integer.toHexString(location.hashCode()) + "_" + location.substring(location.lastIndexOf(47) + 1);
                    file = new File(this.myResourcePath, name.lastIndexOf(46) == -1 ? name + ".xml" : name);
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        NetUtils.copyStreamContent((ProgressIndicator)this.myProgress, (InputStream)in, (OutputStream)out, (int)total);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
                try {
                    final File _file = file;
                    final Set[] resourceDependencies = new Set[1];
                    new WriteAction(){

                        protected void run(Result result) throws Throwable {
                            final VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(_file);
                            if (vf != null) {
                                PsiFile psiFile = PsiManager.getInstance((Project)DownloadManager.this.myProject).findFile(vf);
                                if (psiFile != null && DownloadManager.this.isAccepted(psiFile)) {
                                    resourceDependencies[0] = DownloadManager.this.getResourceDependencies(psiFile);
                                    resourceManager.addResource(location, _file.getAbsolutePath());
                                } else {
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Messages.showErrorDialog((Project)DownloadManager.this.myProject, (String)("Not a valid file: " + vf.getPresentableUrl()), (String)"Download Problem");
                                        }
                                    }, DownloadManager.this.myProject.getDisposed());
                                }
                            }
                        }
                    }.execute();
                    if (resourceDependencies[0] != null) {
                        for (String s : resourceDependencies[0]) {
                            this.myProgress.checkCanceled();
                            this.myProgress.setFraction(0.0);
                            this.fetch(s);
                        }
                    }
                }
                catch (Error err) {
                    Throwable e = err.getCause();
                    if (e instanceof InterruptedException) {
                        break block23;
                    }
                    if (e instanceof InvocationTargetException) {
                        Throwable targetException = ((InvocationTargetException)e).getTargetException();
                        if (targetException instanceof RuntimeException) {
                            throw (RuntimeException)targetException;
                        }
                        if (targetException instanceof IOException) {
                            throw (IOException)targetException;
                        }
                        if (targetException instanceof InterruptedException) {
                        } else {
                            Logger.getInstance((String)this.getClass().getName()).error(e);
                        }
                        break block23;
                    }
                    throw err;
                }
            }
            catch (IOException e) {
                throw new DownloadException(location, e);
            }
            finally {
                if (file != null && resourceManager.getResourceLocation(location) == location) {
                    file.delete();
                }
            }
        }
    }

    protected abstract boolean isAccepted(PsiFile var1);

    protected abstract Set<String> getResourceDependencies(PsiFile var1);

    public static class DownloadException
    extends IOException {
        private final String myLocation;

        public DownloadException(String location, IOException cause) {
            this.myLocation = location;
            this.initCause(cause);
        }

        public String getLocation() {
            return this.myLocation;
        }
    }
}

