/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceInForm
implements PsiReference {
    protected final PsiPlainTextFile myFile;
    private final RangeMarker myRangeMarker;

    protected ReferenceInForm(PsiPlainTextFile file, TextRange range) {
        this.myFile = file;
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile.getVirtualFile());
        this.myRangeMarker = document.createRangeMarker(range);
    }

    public PsiElement getElement() {
        return this.myFile;
    }

    public PsiElement handleElementRename(String newElementName) {
        return this.handleElementRenameBase(newElementName);
    }

    private PsiElement handleElementRenameBase(String newElementName) {
        this.updateRangeText(newElementName);
        return this.myFile;
    }

    public TextRange getRangeInElement() {
        return TextRange.create((Segment)this.myRangeMarker);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ReferenceInForm", "getCanonicalText"));
        }
        return string;
    }

    protected void updateRangeText(String text) {
        Document document = this.myRangeMarker.getDocument();
        document.replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), (CharSequence)text);
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitDocument(document);
    }

    public String getRangeText() {
        return ((Object)this.myRangeMarker.getDocument().getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset())).toString();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ReferenceInForm", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }

    protected PsiElement handleFileRename(String newElementName, @NonNls String extension, boolean includeExtensionInReference) {
        String extensionInReference;
        String currentName = this.getRangeText();
        String baseName = newElementName.endsWith(extension) ? newElementName.substring(0, newElementName.length() - extension.length()) : newElementName;
        int slashIndex = currentName.lastIndexOf(47);
        String string = extensionInReference = includeExtensionInReference ? extension : "";
        if (slashIndex >= 0) {
            String prefix = currentName.substring(0, slashIndex);
            return this.handleElementRenameBase(prefix + "/" + baseName + extensionInReference);
        }
        return this.handleElementRenameBase(baseName + extensionInReference);
    }
}

