/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNWCConflictDescription17 {
    private File localAbspath;
    private SVNNodeKind nodeKind;
    private ConflictKind kind;
    private String propertyName;
    private boolean isBinary;
    private String mimeType;
    private SVNConflictAction action;
    private SVNConflictReason reason;
    private File baseFile;
    private File theirFile;
    private File myFile;
    private File mergedFile;
    private SVNOperation operation;
    private SVNConflictVersion srcLeftVersion;
    private SVNConflictVersion srcRightVersion;

    public static SVNWCConflictDescription17 createText(File localAbspath) {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNWCConflictDescription17 conflict = new SVNWCConflictDescription17();
        conflict.localAbspath = localAbspath;
        conflict.nodeKind = SVNNodeKind.FILE;
        conflict.kind = ConflictKind.TEXT;
        conflict.action = SVNConflictAction.EDIT;
        conflict.reason = SVNConflictReason.EDITED;
        return conflict;
    }

    public static SVNWCConflictDescription17 createProp(File localAbspath, SVNNodeKind nodeKind, String propertyName) {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNWCConflictDescription17 conflict = new SVNWCConflictDescription17();
        conflict.localAbspath = localAbspath;
        conflict.nodeKind = nodeKind;
        conflict.kind = ConflictKind.PROPERTY;
        conflict.propertyName = propertyName;
        return conflict;
    }

    public static SVNWCConflictDescription17 createTree(File localAbspath, SVNNodeKind nodeKind, SVNOperation operation, SVNConflictVersion srcLeftVersion, SVNConflictVersion srcRightVersion) {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNWCConflictDescription17 conflict = new SVNWCConflictDescription17();
        conflict.localAbspath = localAbspath;
        conflict.nodeKind = nodeKind;
        conflict.kind = ConflictKind.TREE;
        conflict.operation = operation;
        conflict.srcLeftVersion = srcLeftVersion;
        conflict.srcRightVersion = srcRightVersion;
        return conflict;
    }

    public SVNConflictDescription toConflictDescription() {
        String wcPath = this.localAbspath != null ? this.localAbspath.getPath() : null;
        switch (this.kind) {
            case PROPERTY: {
                return new SVNPropertyConflictDescription(new SVNMergeFileSet(null, null, this.baseFile, this.myFile, wcPath, this.theirFile, this.mergedFile, null, this.mimeType), this.nodeKind, this.propertyName, this.action, this.reason);
            }
            case TEXT: {
                return new SVNTextConflictDescription(new SVNMergeFileSet(null, null, this.baseFile, this.myFile, wcPath, this.theirFile, this.mergedFile, null, this.mimeType), this.nodeKind, this.action, this.reason);
            }
            case TREE: {
                return new SVNTreeConflictDescription(this.localAbspath, this.nodeKind, this.action, this.reason, this.operation, this.srcLeftVersion, this.srcRightVersion);
            }
        }
        return null;
    }

    public File getLocalAbspath() {
        return this.localAbspath;
    }

    public void setLocalAbspath(File localAbspath) {
        this.localAbspath = localAbspath;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(SVNNodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    public ConflictKind getKind() {
        return this.kind;
    }

    public void setKind(ConflictKind kind) {
        this.kind = kind;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean isBinary) {
        this.isBinary = isBinary;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public SVNConflictAction getAction() {
        return this.action;
    }

    public void setAction(SVNConflictAction action) {
        this.action = action;
    }

    public SVNConflictReason getReason() {
        return this.reason;
    }

    public void setReason(SVNConflictReason reason) {
        this.reason = reason;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(File baseFile) {
        this.baseFile = baseFile;
    }

    public File getTheirFile() {
        return this.theirFile;
    }

    public void setTheirFile(File theirFile) {
        this.theirFile = theirFile;
    }

    public File getMyFile() {
        return this.myFile;
    }

    public void setMyFile(File file) {
        this.myFile = file;
    }

    public File getMergedFile() {
        return this.mergedFile;
    }

    public void setMergedFile(File mergedFile) {
        this.mergedFile = mergedFile;
    }

    public SVNOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SVNOperation operation) {
        this.operation = operation;
    }

    public SVNConflictVersion getSrcLeftVersion() {
        return this.srcLeftVersion;
    }

    public void setSrcLeftVersion(SVNConflictVersion srcLeftVersion) {
        this.srcLeftVersion = srcLeftVersion;
    }

    public SVNConflictVersion getSrcRightVersion() {
        return this.srcRightVersion;
    }

    public void setSrcRightVersion(SVNConflictVersion srcRightVersion) {
        this.srcRightVersion = srcRightVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConflictKind {
        TEXT,
        PROPERTY,
        TREE;

    }
}

