/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;

public class SetKeywordsDialog
extends DialogWrapper {
    private final String myPropValue;
    private JCheckBox myLastChangedDateCheckbox;
    private JCheckBox myLastChangedRevisionCheckbox;
    private JCheckBox myLastChangedByCheckbox;
    private JCheckBox myURLCheckbox;
    private JCheckBox myIDCheckbox;

    protected SetKeywordsDialog(Project project, String propValue) {
        super(project, false);
        this.myPropValue = propValue;
        this.setTitle("SVN Keywords");
        this.setResizable(false);
        this.init();
    }

    public String getKeywords() {
        StringBuffer result = new StringBuffer();
        if (this.myLastChangedDateCheckbox.isSelected()) {
            result.append("LastChangedDate ");
        }
        if (this.myLastChangedByCheckbox.isSelected()) {
            result.append("LastChangedBy ");
        }
        if (this.myLastChangedRevisionCheckbox.isSelected()) {
            result.append("LastChangedRevision ");
        }
        if (this.myURLCheckbox.isSelected()) {
            result.append("HeadURL ");
        }
        if (this.myIDCheckbox.isSelected()) {
            result.append("Id");
        }
        if (result.length() > 0) {
            return result.toString().trim();
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Select keywords to set: "), "North");
        JPanel buttonsPanel = new JPanel(new GridLayout(5, 1));
        this.myIDCheckbox = new JCheckBox("Id");
        this.myURLCheckbox = new JCheckBox("HeadURL");
        this.myLastChangedDateCheckbox = new JCheckBox("LastChangedDate");
        this.myLastChangedRevisionCheckbox = new JCheckBox("LastChangedRevision");
        this.myLastChangedByCheckbox = new JCheckBox("LastChangedBy");
        buttonsPanel.add(this.myIDCheckbox);
        buttonsPanel.add(this.myURLCheckbox);
        buttonsPanel.add(this.myLastChangedByCheckbox);
        buttonsPanel.add(this.myLastChangedDateCheckbox);
        buttonsPanel.add(this.myLastChangedRevisionCheckbox);
        panel.add((Component)buttonsPanel, "Center");
        this.initValues();
        return panel;
    }

    private void initValues() {
        Map keywords = SVNTranslator.computeKeywords((String)this.myPropValue, (String)"u", (String)"a", (String)"d", (String)"r", null);
        this.myLastChangedDateCheckbox.setSelected(keywords.containsKey("LastChangedDate"));
        this.myLastChangedByCheckbox.setSelected(keywords.containsKey("LastChangedBy"));
        this.myLastChangedRevisionCheckbox.setSelected(keywords.containsKey("LastChangedRevision"));
        this.myURLCheckbox.setSelected(keywords.containsKey("HeadURL"));
        this.myIDCheckbox.setSelected(keywords.containsKey("Id"));
    }
}

