/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.TypeConversionUtil");
    private static final boolean[][] IS_ASSIGNABLE_BIT_SET = new boolean[][]{{true, true, false, true, true, true, true}, {false, true, false, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, true}, {false, false, false, false, false, false, true}};
    private static final TObjectIntHashMap<PsiType> TYPE_TO_RANK_MAP = new TObjectIntHashMap();
    public static final int BYTE_RANK = 1;
    public static final int SHORT_RANK = 2;
    public static final int CHAR_RANK = 3;
    public static final int INT_RANK = 4;
    public static final int LONG_RANK = 5;
    private static final int FLOAT_RANK = 6;
    private static final int DOUBLE_RANK = 7;
    private static final int BOOL_RANK = 10;
    private static final int STRING_RANK = 100;
    private static final int MAX_NUMERIC_RANK = 7;
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getPresentableText() {
            if ("FAKE TYPE" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$1", "getPresentableText"));
            }
            return "FAKE TYPE";
        }
    };
    private static final Key<CachedValue<Set<String>>> POSSIBLE_BOXED_HOLDER_TYPES;
    private static final RecursionGuard ourGuard;
    private static final Set<String> ourReportedSuperClassSubstitutorExceptions;
    private static final Set<String> INTEGER_NUMBER_TYPES;
    private static final Set<String> PRIMITIVE_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_TYPES;
    private static final Caster[][] caster;
    private static final Map<Class, PsiType> WRAPPER_TO_PRIMITIVE;

    private TypeConversionUtil() {
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        return TypeConversionUtil.areTypesConvertible(fromType, toType, null);
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType, @Nullable LanguageLevel languageLevel) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (fromType == toType) {
            return true;
        }
        boolean fromIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(fromType);
        boolean toIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(toType);
        if (fromIsPrimitive || toIsPrimitive) {
            if (TypeConversionUtil.isVoidType(fromType) || TypeConversionUtil.isVoidType(toType)) {
                return false;
            }
            int fromTypeRank = TypeConversionUtil.getTypeRank(fromType);
            int toTypeRank = TypeConversionUtil.getTypeRank(toType);
            if (!toIsPrimitive) {
                if (fromTypeRank == toTypeRank) {
                    return true;
                }
                if (toType instanceof PsiIntersectionType) {
                    for (PsiType type : ((PsiIntersectionType)toType).getConjuncts()) {
                        if (TypeConversionUtil.areTypesConvertible(fromType, type)) continue;
                        return false;
                    }
                    return true;
                }
                if (!(toType instanceof PsiClassType)) {
                    return false;
                }
                PsiClass toClass = ((PsiClassType)toType).resolve();
                if (toClass == null || toClass instanceof PsiTypeParameter) {
                    return false;
                }
                PsiClassType boxedType = ((PsiPrimitiveType)fromType).getBoxedType(toClass.getManager(), toType.getResolveScope());
                return boxedType != null && TypeConversionUtil.areTypesConvertible(boxedType, toType);
            }
            if (!fromIsPrimitive) {
                if ((fromTypeRank == 2 || fromTypeRank == 1) && toTypeRank == 3) {
                    return false;
                }
                if (fromType instanceof PsiClassType) {
                    if (languageLevel == null) {
                        languageLevel = ((PsiClassType)fromType).getLanguageLevel();
                    }
                    if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                        PsiClassType classType = (PsiClassType)fromType;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass == null || psiClass instanceof PsiTypeParameter) {
                            return false;
                        }
                        PsiClassType boxedType = ((PsiPrimitiveType)toType).getBoxedType(psiClass.getManager(), psiClass.getResolveScope());
                        if (boxedType != null && TypeConversionUtil.isAssignable(fromType, boxedType)) {
                            return true;
                        }
                    }
                }
                return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7 && fromTypeRank < toTypeRank;
            }
            return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7;
        }
        if (TypeConversionUtil.isAssignable(toType, fromType)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(fromType) || TypeConversionUtil.isNullType(toType)) {
            return true;
        }
        return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, toType);
    }

    private static boolean isNarrowingReferenceConversionAllowed(@NotNull PsiType fromType, @NotNull PsiType toType) {
        PsiSubstitutor derivedSubstitutor;
        PsiClass derived;
        PsiClassType.ClassResolveResult baseResult;
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/intellij/psi/util/TypeConversionUtil", "isNarrowingReferenceConversionAllowed"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/psi/util/TypeConversionUtil", "isNarrowingReferenceConversionAllowed"));
        }
        if (toType instanceof PsiPrimitiveType || fromType instanceof PsiPrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PsiDiamondType || fromType instanceof PsiDiamondType) {
            return false;
        }
        if (toType instanceof PsiArrayType && !(fromType instanceof PsiArrayType)) {
            PsiClass resolved;
            if (fromType instanceof PsiClassType && (resolved = ((PsiClassType)fromType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(boundType, toType)) continue;
                    return false;
                }
                return true;
            }
            return TypeConversionUtil.isAssignable(fromType, toType);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass resolved;
            if (toType instanceof PsiClassType && (resolved = ((PsiClassType)toType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.areTypesConvertible(fromType, boundType)) continue;
                    return false;
                }
                return true;
            }
            return toType instanceof PsiArrayType && TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiArrayType)fromType).getComponentType(), ((PsiArrayType)toType).getComponentType());
        }
        if (fromType instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)fromType).getConjuncts()) {
                if (!TypeConversionUtil.isNarrowingReferenceConversionAllowed(conjunct, toType)) continue;
                return true;
            }
            return false;
        }
        if (toType instanceof PsiIntersectionType) {
            if (fromType instanceof PsiClassType && ((PsiClassType)fromType).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8)) {
                for (PsiType conjunct : ((PsiIntersectionType)toType).getConjuncts()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, conjunct)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (fromType instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiDisjunctionType)fromType).getLeastUpperBound(), toType);
        }
        if (toType instanceof PsiDisjunctionType) {
            return false;
        }
        if (fromType instanceof PsiWildcardType) {
            PsiWildcardType fromWildcard = (PsiWildcardType)fromType;
            PsiType bound = fromWildcard.getBound();
            if (bound == null) {
                return true;
            }
            if (fromWildcard.isSuper()) {
                return TypeConversionUtil.isAssignable(toType, bound);
            }
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(bound, toType);
        }
        if (toType instanceof PsiWildcardType) {
            PsiWildcardType toWildcard = (PsiWildcardType)toType;
            if (toWildcard.isSuper()) {
                return false;
            }
            PsiType bound = toWildcard.getBound();
            return bound == null || TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, bound);
        }
        if (toType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, ((PsiCapturedWildcardType)toType).getWildcard());
        }
        if (fromType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiCapturedWildcardType)fromType).getWildcard(), toType);
        }
        if (TypeConversionUtil.isAssignable(fromType, toType)) {
            return true;
        }
        if (!(fromType instanceof PsiClassType) || !(toType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType fromClassType = (PsiClassType)fromType;
        PsiClassType toClassType = (PsiClassType)toType;
        PsiClassType.ClassResolveResult fromResult = fromClassType.resolveGenerics();
        PsiClass fromClass = fromResult.getElement();
        if (fromClass == null) {
            return false;
        }
        if (fromClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)fromClass), toType);
        }
        PsiClassType.ClassResolveResult toResult = toClassType.resolveGenerics();
        PsiClass toClass = toResult.getElement();
        if (toClass == null) {
            return false;
        }
        if (toClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)toClass));
        }
        PsiManager manager = fromClass.getManager();
        LanguageLevel languageLevel = toClassType.getLanguageLevel();
        if (!fromClass.isInterface()) {
            if (toClass.isInterface()) {
                return (!fromClass.hasModifierProperty("final") || fromClass.isInheritor(toClass, true)) && TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            if (manager.areElementsEquivalent(fromClass, toClass)) {
                return TypeConversionUtil.areSameParameterTypes(fromClassType, toClassType);
            }
            if (toClass.isInheritor(fromClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            if (fromClass.isInheritor(toClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            return false;
        }
        if (!toClass.isInterface()) {
            if (!toClass.hasModifierProperty("final")) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            PsiSubstitutor toSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(fromClass, toClass, toResult.getSubstitutor(), null);
            return toSubstitutor != null && TypeConversionUtil.areSameArgumentTypes(fromClass, fromResult.getSubstitutor(), toSubstitutor);
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            Collection<HierarchicalMethodSignature> fromClassMethodSignatures = fromClass.getVisibleSignatures();
            Collection<HierarchicalMethodSignature> toClassMethodSignatures = toClass.getVisibleSignatures();
            for (HierarchicalMethodSignature fromMethodSignature : fromClassMethodSignatures) {
                for (HierarchicalMethodSignature toMethodSignature : toClassMethodSignatures) {
                    if (!fromMethodSignature.equals(toMethodSignature)) continue;
                    PsiType fromClassReturnType = fromMethodSignature.getMethod().getReturnType();
                    PsiType toClassReturnType = toMethodSignature.getMethod().getReturnType();
                    if (fromClassReturnType == null || toClassReturnType == null || fromClassReturnType.equals(toClassReturnType)) continue;
                    return false;
                }
            }
            return true;
        }
        if (toClass.isInheritor(fromClass, true)) {
            baseResult = fromResult;
            derived = toClass;
            derivedSubstitutor = toResult.getSubstitutor();
        } else {
            baseResult = toResult;
            derived = fromClass;
            derivedSubstitutor = fromResult.getSubstitutor();
        }
        return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, derived, manager, derivedSubstitutor, null, languageLevel);
    }

    @NotNull
    private static PsiClassType obtainSafeSuperType(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
        }
        PsiClassType superType = typeParameter.getSuperTypes()[0];
        PsiClassType.ClassResolveResult result = superType.resolveGenerics();
        PsiClass superClass = result.getElement();
        if (superClass != null) {
            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, null);
            PsiClassType psiClassType = JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(superClass, substitutor);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = superType;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
        }
        return psiClassType;
    }

    private static boolean checkSuperTypesWithDifferentTypeArguments(@NotNull PsiClassType.ClassResolveResult baseResult, @NotNull PsiClass derived, @NotNull PsiManager manager, @NotNull PsiSubstitutor derivedSubstitutor, Set<PsiClass> visited, @NotNull LanguageLevel languageLevel) {
        if (baseResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseResult", "com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (derived == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derived", "com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (visited != null && visited.contains(derived)) {
            return true;
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            return true;
        }
        PsiClass base = baseResult.getElement();
        PsiClass[] supers = derived.getSupers();
        if (manager.areElementsEquivalent(base, derived)) {
            derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor);
            return TypeConversionUtil.areSameArgumentTypes(derived, baseResult.getSubstitutor(), derivedSubstitutor, 1);
        }
        PsiSubstitutor baseSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(derived, base, baseResult.getSubstitutor(), null);
        if (baseSubstitutor != null && !TypeConversionUtil.areSameArgumentTypes(derived, baseSubstitutor, derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor))) {
            return false;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        visited.add((PsiClass)derived);
        for (PsiClass aSuper : supers) {
            PsiSubstitutor s = TypeConversionUtil.getSuperClassSubstitutor(aSuper, derived, derivedSubstitutor);
            if (TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, aSuper, manager, s, (Set<PsiClass>)visited, languageLevel)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameParameterTypes(@NotNull PsiClassType type1, @NotNull PsiClassType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/psi/util/TypeConversionUtil", "areSameParameterTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/psi/util/TypeConversionUtil", "areSameParameterTypes"));
        }
        PsiClassType.ClassResolveResult resolveResult1 = type1.resolveGenerics();
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass aClass = resolveResult1.getElement();
        PsiClass bClass = resolveResult2.getElement();
        return aClass != null && bClass != null && aClass.getManager().areElementsEquivalent(aClass, bClass) && TypeConversionUtil.areSameArgumentTypes(aClass, resolveResult1.getSubstitutor(), resolveResult2.getSubstitutor(), 1);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        return TypeConversionUtil.areSameArgumentTypes(aClass, substitutor1, substitutor2, 0);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2, int level) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiType typeArg1 = substitutor1.substitute(typeParameter);
            PsiType typeArg2 = substitutor2.substitute(typeParameter);
            if (typeArg1 == null || typeArg2 == null) {
                return true;
            }
            if (TypesDistinctProver.provablyDistinct(typeArg1, typeArg2, level)) {
                return false;
            }
            PsiClass class1 = PsiUtil.resolveClassInType(typeArg1);
            if (!(class1 instanceof PsiTypeParameter)) continue;
            for (PsiClassType type : class1.getExtendsListTypes()) {
                if (!TypesDistinctProver.provablyDistinct(type, typeArg2) || TypeConversionUtil.isAssignable(type, typeArg2)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPrimitiveAndNotNull(PsiType type) {
        return type instanceof PsiPrimitiveType && !TypeConversionUtil.isNullType(type);
    }

    public static boolean isEnumType(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && psiClass.isEnum();
        }
        return false;
    }

    public static boolean isNullType(PsiType type) {
        return PsiType.NULL.equals(type);
    }

    public static boolean isFloatOrDoubleType(PsiType type) {
        return TypeConversionUtil.isFloatType(type) || TypeConversionUtil.isDoubleType(type);
    }

    public static boolean isDoubleType(PsiType type) {
        return PsiType.DOUBLE.equals(type) || PsiType.DOUBLE.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isFloatType(PsiType type) {
        return PsiType.FLOAT.equals(type) || PsiType.FLOAT.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isLongType(PsiType type) {
        return PsiType.LONG.equals(type) || PsiType.LONG.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isVoidType(PsiType type) {
        return PsiType.VOID.equals(type);
    }

    public static boolean isBooleanType(@Nullable PsiType type) {
        return PsiType.BOOLEAN.equals(type) || PsiType.BOOLEAN.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isNumericType(int typeRank) {
        return typeRank <= 7;
    }

    public static boolean isNumericType(PsiType type) {
        return type != null && TypeConversionUtil.isNumericType(TypeConversionUtil.getTypeRank(type));
    }

    public static int getTypeRank(@NotNull PsiType type) {
        int rank;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/TypeConversionUtil", "getTypeRank"));
        }
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(type);
        if (unboxedType != null) {
            type = unboxedType;
        }
        if ((rank = TYPE_TO_RANK_MAP.get((Object)type)) != 0) {
            return rank;
        }
        if (type.equalsToText("java.lang.String")) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiExpression lOperand, PsiExpression rOperand, boolean strict) {
        if (lOperand == null || rOperand == null) {
            return true;
        }
        PsiType ltype = lOperand.getType();
        PsiType rtype = rOperand.getType();
        return TypeConversionUtil.isBinaryOperatorApplicable(tokenType, ltype, rtype, strict);
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiType ltype, PsiType rtype, boolean strict) {
        if (ltype == null || rtype == null) {
            return true;
        }
        int resultTypeRank = 10;
        boolean isApplicable = false;
        int ltypeRank = TypeConversionUtil.getTypeRank(ltype);
        int rtypeRank = TypeConversionUtil.getTypeRank(rtype);
        if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype) && (TypeConversionUtil.isPrimitiveAndNotNull(ltype) || TypeConversionUtil.isPrimitiveAndNotNull(rtype))) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7 || ltypeRank == 10 && rtypeRank == 10;
            } else {
                if (TypeConversionUtil.isPrimitiveAndNotNull(ltype)) {
                    LanguageLevel languageLevel;
                    return rtype instanceof PsiClassType && (languageLevel = ((PsiClassType)rtype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_5) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(ltype, rtype);
                }
                if (TypeConversionUtil.isPrimitiveAndNotNull(rtype)) {
                    LanguageLevel level;
                    return ltype instanceof PsiClassType && (level = ((PsiClassType)ltype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7) && !level.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(rtype, ltype);
                }
                isApplicable = TypeConversionUtil.areTypesConvertible(ltype, rtype) || TypeConversionUtil.areTypesConvertible(rtype, ltype);
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (ltype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(rtype);
                resultTypeRank = 100;
            } else if (rtype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(ltype);
                resultTypeRank = 100;
            } else if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.ASTERISK || tokenType == JavaTokenType.DIV || tokenType == JavaTokenType.PERC || tokenType == JavaTokenType.MINUS) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.LTLT || tokenType == JavaTokenType.GTGT || tokenType == JavaTokenType.GTGTGT) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5;
                resultTypeRank = 4;
            }
        } else if (tokenType == JavaTokenType.AND || tokenType == JavaTokenType.OR || tokenType == JavaTokenType.XOR) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5 || TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
                resultTypeRank = ltypeRank <= 5 ? 4 : 10;
            }
        } else if ((tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
            boolean bl = isApplicable = TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
        }
        if (isApplicable && strict) {
            isApplicable = resultTypeRank > 7 ? ltypeRank == resultTypeRank || ltype.equalsToText("java.lang.Object") : ltypeRank <= 7;
        }
        return isApplicable;
    }

    public static boolean isPrimitiveAndNotNullOrWrapper(PsiType type) {
        if (type instanceof PsiClassType) {
            return PsiPrimitiveType.getUnboxedType(type) != null;
        }
        return TypeConversionUtil.isPrimitiveAndNotNull(type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, PsiExpression operand) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        if (operand == null) {
            return false;
        }
        PsiType type = operand.getType();
        return type != null && TypeConversionUtil.isUnaryOperatorApplicable(token, type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, @NotNull PsiType type) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        IElementType i = token.getTokenType();
        int typeRank = TypeConversionUtil.getTypeRank(type);
        if (i == JavaTokenType.MINUSMINUS || i == JavaTokenType.PLUSPLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.MINUS || i == JavaTokenType.PLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.TILDE) {
            return typeRank <= 5;
        }
        if (i == JavaTokenType.EXCL) {
            return typeRank == 10;
        }
        LOG.error("unknown token: " + token);
        return true;
    }

    public static boolean isLValue(PsiExpression element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)element;
            PsiElement resolved = expression.resolve();
            return resolved instanceof PsiVariable;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return TypeConversionUtil.isLValue(((PsiParenthesizedExpression)element).getExpression());
        }
        if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type = arrayExpression.getType();
            if (type == null || !(type instanceof PsiArrayType)) {
                return false;
            }
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            PsiType indexType = indexExpression.getType();
            if (indexType == null) {
                return false;
            }
            if (TypeConversionUtil.getTypeRank(indexType) <= 4) {
                return true;
            }
        }
        return false;
    }

    public static boolean areTypesAssignmentCompatible(PsiType lType, PsiExpression rExpr) {
        if (lType == null || rExpr == null) {
            return true;
        }
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable(lType, rType)) {
            return true;
        }
        if (lType instanceof PsiClassType && (lType = PsiPrimitiveType.getUnboxedType(lType)) == null) {
            return false;
        }
        int rTypeRank = TypeConversionUtil.getTypeRank(rType);
        if (lType instanceof PsiPrimitiveType && rType instanceof PsiPrimitiveType && rTypeRank >= 1 && rTypeRank <= 4) {
            long value;
            Object rValue = JavaPsiFacade.getInstance(rExpr.getProject()).getConstantEvaluationHelper().computeConstantExpression(rExpr);
            if (rValue instanceof Number) {
                value = ((Number)rValue).longValue();
            } else if (rValue instanceof Character) {
                value = ((Character)rValue).charValue();
            } else {
                return false;
            }
            if (PsiType.BYTE.equals(lType)) {
                return -128L <= value && value <= 127L;
            }
            if (PsiType.SHORT.equals(lType)) {
                return -32768L <= value && value <= 32767L;
            }
            if (PsiType.CHAR.equals(lType)) {
                return 0L <= value && value <= 65535L;
            }
        }
        return false;
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        return TypeConversionUtil.isAssignable(left, right, true);
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (left == right || left.equals(right)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(right)) {
            return !(left instanceof PsiPrimitiveType) || TypeConversionUtil.isNullType(left);
        }
        if (right instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression methodReferenceExpression = ((PsiMethodReferenceType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiLambdaExpressionType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            if (left instanceof PsiMethodReferenceType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiMethodReferenceType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            return !(left instanceof PsiArrayType) && methodReferenceExpression.isAcceptable(left);
        }
        if (right instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression rLambdaExpression = ((PsiLambdaExpressionType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiLambdaExpression lLambdaExpression = ((PsiLambdaExpressionType)left).getExpression();
                PsiType rType = rLambdaExpression.getFunctionalInterfaceType();
                PsiType lType = lLambdaExpression.getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            return !(left instanceof PsiArrayType) && rLambdaExpression.isAcceptable(left, false);
        }
        if (left instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, right, allowUncheckedConversion)) continue;
                return false;
            }
            return true;
        }
        if (right instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)right).getConjuncts()) {
                if (!TypeConversionUtil.isAssignable(left, conjunct, allowUncheckedConversion)) continue;
                return true;
            }
            return false;
        }
        if (left instanceof PsiCapturedWildcardType) {
            return left.equals(right) || TypeConversionUtil.isAssignable(((PsiCapturedWildcardType)left).getLowerBound(), right, allowUncheckedConversion);
        }
        if (right instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isAssignable(left, ((PsiCapturedWildcardType)right).getUpperBound(), allowUncheckedConversion);
        }
        if (left instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableToWildcard((PsiWildcardType)left, right);
        }
        if (right instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableFromWildcard(left, (PsiWildcardType)right);
        }
        if (right instanceof PsiArrayType) {
            if (!(left instanceof PsiArrayType)) {
                if (left instanceof PsiPrimitiveType || PsiUtil.resolveClassInType(left) == null) {
                    return false;
                }
                PsiClass lClass = PsiUtil.resolveClassInType(left);
                if (lClass == null) {
                    return false;
                }
                if (lClass.isInterface()) {
                    String qualifiedName = lClass.getQualifiedName();
                    return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
                }
                return left.equalsToText("java.lang.Object");
            }
            PsiType lCompType = ((PsiArrayType)left).getComponentType();
            PsiType rCompType = ((PsiArrayType)right).getComponentType();
            if (lCompType instanceof PsiPrimitiveType) {
                return lCompType.equals(rCompType);
            }
            return !(rCompType instanceof PsiPrimitiveType) && TypeConversionUtil.isAssignable(lCompType, rCompType, allowUncheckedConversion);
        }
        if (left instanceof PsiDisjunctionType) {
            for (PsiType type : ((PsiDisjunctionType)left).getDisjunctions()) {
                if (!TypeConversionUtil.isAssignable(type, right, allowUncheckedConversion)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isAssignable(left, ((PsiDisjunctionType)right).getLeastUpperBound(), allowUncheckedConversion);
        }
        if (left instanceof PsiArrayType) {
            return false;
        }
        if (right instanceof PsiPrimitiveType) {
            if (TypeConversionUtil.isVoidType(right)) {
                return false;
            }
            if (!(left instanceof PsiPrimitiveType)) {
                return left instanceof PsiClassType && TypeConversionUtil.isBoxable((PsiClassType)left, (PsiPrimitiveType)right);
            }
            int leftTypeIndex = TYPE_TO_RANK_MAP.get((Object)left) - 1;
            int rightTypeIndex = TYPE_TO_RANK_MAP.get((Object)right) - 1;
            return leftTypeIndex >= 0 && rightTypeIndex >= 0 && rightTypeIndex < IS_ASSIGNABLE_BIT_SET.length && leftTypeIndex < IS_ASSIGNABLE_BIT_SET.length && IS_ASSIGNABLE_BIT_SET[rightTypeIndex][leftTypeIndex];
        }
        if (!(right instanceof PsiClassType)) {
            return false;
        }
        if (left instanceof PsiPrimitiveType) {
            return TypeConversionUtil.isUnboxable((PsiPrimitiveType)left, (PsiClassType)right);
        }
        PsiClassType.ClassResolveResult leftResult = PsiUtil.resolveGenericsClassInType(left);
        PsiClassType.ClassResolveResult rightResult = PsiUtil.resolveGenericsClassInType(right);
        if (leftResult.getElement() == null || rightResult.getElement() == null) {
            String rText;
            if (leftResult.getElement() != rightResult.getElement()) {
                return false;
            }
            String lText = left.getPresentableText();
            if (lText.equals(rText = right.getPresentableText())) {
                return true;
            }
            if (lText.length() > rText.length() && lText.endsWith(rText) && lText.charAt(lText.length() - rText.length() - 1) == '.') {
                return true;
            }
            return rText.length() > lText.length() && rText.endsWith(lText) && rText.charAt(rText.length() - lText.length() - 1) == '.';
        }
        return TypeConversionUtil.isClassAssignable(leftResult, rightResult, allowUncheckedConversion);
    }

    private static boolean isAssignableFromWildcard(@NotNull PsiType left, @NotNull PsiWildcardType rightWildcardType) {
        PsiClass aClass;
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/psi/util/TypeConversionUtil", "isAssignableFromWildcard"));
        }
        if (rightWildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightWildcardType", "com/intellij/psi/util/TypeConversionUtil", "isAssignableFromWildcard"));
        }
        if (rightWildcardType.isSuper() && (aClass = PsiUtil.resolveClassInType(rightWildcardType.getSuperBound())) instanceof PsiTypeParameter) {
            PsiClassType[] types;
            for (PsiClassType type : types = aClass.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(left, type)) continue;
                return true;
            }
        }
        return TypeConversionUtil.isAssignable(left, rightWildcardType.getExtendsBound());
    }

    private static boolean isAssignableToWildcard(@NotNull PsiWildcardType wildcardType, @NotNull PsiType right) {
        if (wildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardType", "com/intellij/psi/util/TypeConversionUtil", "isAssignableToWildcard"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/psi/util/TypeConversionUtil", "isAssignableToWildcard"));
        }
        if (wildcardType.isSuper()) {
            return TypeConversionUtil.isAssignable(wildcardType.getSuperBound(), right);
        }
        return TypeConversionUtil.isAssignable(wildcardType.getExtendsBound(), right);
    }

    private static boolean isUnboxable(@NotNull PsiPrimitiveType left, @NotNull PsiClassType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/psi/util/TypeConversionUtil", "isUnboxable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/psi/util/TypeConversionUtil", "isUnboxable"));
        }
        PsiPrimitiveType rightUnboxedType = PsiPrimitiveType.getUnboxedType(right);
        return rightUnboxedType != null && TypeConversionUtil.isAssignable(left, rightUnboxedType);
    }

    public static boolean boxingConversionApplicable(PsiType left, PsiType right) {
        if (left instanceof PsiPrimitiveType && !PsiType.NULL.equals(left)) {
            return right instanceof PsiClassType && TypeConversionUtil.isAssignable(left, right);
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType lConjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.boxingConversionApplicable(lConjunct, right)) continue;
                return false;
            }
            return true;
        }
        return left instanceof PsiClassType && right instanceof PsiPrimitiveType && !PsiType.NULL.equals(right) && TypeConversionUtil.isAssignable(left, right);
    }

    private static boolean isBoxable(@NotNull PsiClassType left, @NotNull PsiPrimitiveType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/psi/util/TypeConversionUtil", "isBoxable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/psi/util/TypeConversionUtil", "isBoxable"));
        }
        if (!left.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = left.resolve();
        if (psiClass == null) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null || !TypeConversionUtil.getAllBoxedTypeSupers(psiClass).contains(qname)) {
            return false;
        }
        PsiClassType rightBoxed = right.getBoxedType(psiClass.getManager(), left.getResolveScope());
        return rightBoxed != null && TypeConversionUtil.isAssignable(left, rightBoxed);
    }

    @NotNull
    private static Set<String> getAllBoxedTypeSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/util/TypeConversionUtil", "getAllBoxedTypeSupers"));
        }
        PsiManager manager = psiClass.getManager();
        final Project project = psiClass.getProject();
        CachedValue<Set<String>> boxedHolderTypes = (CachedValue<Set<String>>)project.getUserData(POSSIBLE_BOXED_HOLDER_TYPES);
        if (boxedHolderTypes == null) {
            boxedHolderTypes = CachedValuesManager.getManager(manager.getProject()).createCachedValue(new CachedValueProvider<Set<String>>(){

                @Override
                public CachedValueProvider.Result<Set<String>> compute() {
                    JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                    THashSet set = new THashSet();
                    for (String qname : PsiPrimitiveType.getAllBoxedTypeNames()) {
                        PsiClass boxedClass = facade.findClass(qname, GlobalSearchScope.allScope(project));
                        InheritanceUtil.processSupers(boxedClass, true, new Processor<PsiClass>((Set)set){
                            final /* synthetic */ Set val$set;
                            {
                                this.val$set = set;
                            }

                            public boolean process(PsiClass psiClass) {
                                ContainerUtil.addIfNotNull((Object)psiClass.getQualifiedName(), (Collection)this.val$set);
                                return true;
                            }
                        });
                    }
                    return CachedValueProvider.Result.create(set, ProjectRootModificationTracker.getInstance(project));
                }
            }, false);
            project.putUserData(POSSIBLE_BOXED_HOLDER_TYPES, boxedHolderTypes);
        }
        Set set = (Set)boxedHolderTypes.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "getAllBoxedTypeSupers"));
        }
        return set;
    }

    private static boolean isClassAssignable(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion) {
        if (leftResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftResult", "com/intellij/psi/util/TypeConversionUtil", "isClassAssignable"));
        }
        if (rightResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightResult", "com/intellij/psi/util/TypeConversionUtil", "isClassAssignable"));
        }
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        return leftClass != null && rightClass != null && InheritanceUtil.isInheritorOrSelf(rightClass, leftClass, true) && TypeConversionUtil.typeParametersAgree(leftResult, rightResult, allowUncheckedConversion);
    }

    private static boolean typeParametersAgree(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion) {
        if (leftResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftResult", "com/intellij/psi/util/TypeConversionUtil", "typeParametersAgree"));
        }
        if (rightResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightResult", "com/intellij/psi/util/TypeConversionUtil", "typeParametersAgree"));
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        Iterator<PsiTypeParameter> li = PsiUtil.typeParametersIterator(leftClass);
        if (!li.hasNext()) {
            return true;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent(leftClass, rightClass)) {
            rightSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(leftClass, rightClass, rightSubstitutor);
            rightClass = leftClass;
        } else if (!PsiUtil.typeParametersIterator(rightClass).hasNext()) {
            return true;
        }
        Iterator<PsiTypeParameter> ri = PsiUtil.typeParametersIterator(rightClass);
        while (li.hasNext()) {
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = li.next();
            PsiTypeParameter rp = ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType typeRight = rightSubstitutor.substituteWithBoundsPromotion(rp);
            if (typeRight == null) {
                return allowUncheckedConversion;
            }
            if (TypeConversionUtil.typesAgree(typeLeft, typeRight, allowUncheckedConversion)) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAgree(@NotNull PsiType typeLeft, @NotNull PsiType typeRight, final boolean allowUncheckedConversion) {
        if (typeLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeLeft", "com/intellij/psi/util/TypeConversionUtil", "typesAgree"));
        }
        if (typeRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRight", "com/intellij/psi/util/TypeConversionUtil", "typesAgree"));
        }
        if (typeLeft instanceof PsiWildcardType) {
            PsiWildcardType leftWildcard = (PsiWildcardType)typeLeft;
            final PsiType leftBound = leftWildcard.getBound();
            if (leftBound == null) {
                return true;
            }
            if (leftBound.equalsToText("java.lang.Object")) {
                if (!leftWildcard.isSuper()) {
                    return true;
                }
                if (typeRight.equalsToText("java.lang.Object")) {
                    return true;
                }
            }
            if (typeRight instanceof PsiWildcardType) {
                Boolean assignable;
                final PsiWildcardType rightWildcard = (PsiWildcardType)typeRight;
                if (leftWildcard.isExtends()) {
                    return rightWildcard.isExtends() && TypeConversionUtil.isAssignable(leftBound, rightWildcard.getBound(), allowUncheckedConversion);
                }
                return rightWildcard.isSuper() && (assignable = (Boolean)ourGuard.doPreventingRecursion((Object)rightWildcard, true, (Computable)new NotNullComputable<Boolean>(){

                    @NotNull
                    public Boolean compute() {
                        Boolean bl = TypeConversionUtil.isAssignable(rightWildcard.getBound(), leftBound, allowUncheckedConversion);
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$3", "compute"));
                        }
                        return bl;
                    }
                })) != null && assignable != false;
            }
            boolean effectiveAllowUncheckedConversion = allowUncheckedConversion;
            if (typeRight instanceof PsiCapturedWildcardType) {
                effectiveAllowUncheckedConversion = false;
                PsiClass psiClass = PsiUtil.resolveClassInType(((PsiCapturedWildcardType)typeRight).getWildcard().getBound());
                if (psiClass != null && !psiClass.hasTypeParameters()) {
                    effectiveAllowUncheckedConversion = allowUncheckedConversion;
                }
            }
            if (leftWildcard.isExtends()) {
                return TypeConversionUtil.isAssignable(leftBound, typeRight, effectiveAllowUncheckedConversion && !TypeConversionUtil.containsWildcards(leftBound));
            }
            return TypeConversionUtil.isAssignable(typeRight, leftBound, false);
        }
        return typeLeft.equals(typeRight);
    }

    public static boolean containsWildcards(@NotNull PsiType leftBound) {
        if (leftBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftBound", "com/intellij/psi/util/TypeConversionUtil", "containsWildcards"));
        }
        return leftBound.accept(new WildcardDetector());
    }

    @Nullable
    public static PsiSubstitutor getClassSubstitutor(@NotNull PsiClass superClassCandidate, @NotNull PsiClass derivedClassCandidate, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClassCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassCandidate", "com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (derivedClassCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClassCandidate", "com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (superClassCandidate.getManager().areElementsEquivalent(superClassCandidate, derivedClassCandidate)) {
            PsiTypeParameter[] baseParams = superClassCandidate.getTypeParameters();
            PsiTypeParameter[] derivedParams = derivedClassCandidate.getTypeParameters();
            if (baseParams.length > 0 && derivedParams.length == 0) {
                return JavaPsiFacade.getInstance(superClassCandidate.getProject()).getElementFactory().createRawSubstitutor(superClassCandidate);
            }
            return derivedSubstitutor;
        }
        return TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClassCandidate, derivedSubstitutor, null);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (!superClass.hasTypeParameters() && superClass.getContainingClass() == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
            }
            return psiSubstitutor;
        }
        THashSet visited = new THashSet();
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClass, derivedClass, derivedSubstitutor, (Set<PsiClass>)visited);
        if (substitutor == null) {
            if (ourReportedSuperClassSubstitutorExceptions.add(derivedClass.getQualifiedName() + "/" + superClass.getQualifiedName())) {
                TypeConversionUtil.reportHierarchyInconsistency(superClass, derivedClass, (Set<PsiClass>)visited);
            }
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiSubstitutor getMaybeSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor, @Nullable Set<PsiClass> visited) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        if (!superClass.hasTypeParameters() && superClass.getContainingClass() == null) {
            return InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) ? PsiSubstitutor.EMPTY : null;
        }
        PsiManager manager = superClass.getManager();
        if (PsiUtil.isRawSubstitutor(derivedClass, derivedSubstitutor)) {
            return InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) ? JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createRawSubstitutor(superClass) : null;
        }
        if ("Object".equals(superClass.getName()) && manager.areElementsEquivalent(superClass, JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Object", superClass.getResolveScope()))) {
            return PsiSubstitutor.EMPTY;
        }
        if (derivedClass instanceof PsiAnonymousClass) {
            PsiClassType baseType = ((PsiAnonymousClass)derivedClass).getBaseClassType();
            PsiClassType.ClassResolveResult result = baseType.resolveGenerics();
            if (result.getElement() == null) {
                return PsiSubstitutor.UNKNOWN;
            }
            derivedClass = (PsiClass)result.getElement();
            derivedSubstitutor = derivedSubstitutor.putAll(result.getSubstitutor());
        }
        return TypeConversionUtil.getSuperClassSubstitutorInner(superClass, derivedClass, derivedSubstitutor, (Set<PsiClass>)(visited == null ? new THashSet() : visited), manager);
    }

    private static void reportHierarchyInconsistency(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull Set<PsiClass> visited) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        final StringBuilder msg = new StringBuilder("Super: " + TypeConversionUtil.classInfo(superClass));
        msg.append("visited:\n");
        for (PsiClass aClass : visited) {
            msg.append("  each: " + TypeConversionUtil.classInfo(aClass));
        }
        msg.append("isInheritor: " + InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) + " " + derivedClass.isInheritor(superClass, true));
        msg.append("\nhierarchy:\n");
        InheritanceUtil.processSupers(derivedClass, true, new Processor<PsiClass>(){

            public boolean process(PsiClass psiClass) {
                msg.append("each: " + TypeConversionUtil.classInfo(psiClass));
                return true;
            }
        });
        LOG.error(msg.toString());
    }

    @NotNull
    private static String classInfo(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/TypeConversionUtil", "classInfo"));
        }
        String s = aClass.getQualifiedName() + "(" + aClass.getClass().getName() + "; " + PsiUtilCore.getVirtualFile(aClass) + ");\n";
        s = s + "extends: ";
        for (PsiClassType type : aClass.getExtendsListTypes()) {
            s = s + type + " (" + type.getClass().getName() + "; " + type.resolve() + ") ";
        }
        s = s + "\nimplements: ";
        for (PsiClassType type : aClass.getImplementsListTypes()) {
            s = s + type + " (" + type.getClass().getName() + "; " + type.resolve() + ") ";
        }
        String string = s + "\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "classInfo"));
        }
        return string;
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClassType classType) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, classResolveResult.getElement(), classResolveResult.getSubstitutor());
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor getSuperClassSubstitutorInner(@NotNull PsiClass base, @NotNull PsiClass candidate, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull Set<PsiClass> visited, @NotNull PsiManager manager) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutorInner"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutorInner"));
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutorInner"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutorInner"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutorInner"));
        }
        if (!visited.add(candidate)) {
            return null;
        }
        assert (candidateSubstitutor.isValid());
        if (base == candidate) {
            return candidateSubstitutor;
        }
        if (manager.areElementsEquivalent(base, candidate)) {
            PsiTypeParameter[] baseParams = base.getTypeParameters();
            PsiTypeParameter[] candidateParams = candidate.getTypeParameters();
            PsiElementFactory factory = JavaPsiFacade.getInstance(base.getProject()).getElementFactory();
            if (baseParams.length > 0 && candidateParams.length == 0) {
                return factory.createRawSubstitutor(base);
            }
            HashMap m = new HashMap();
            for (int i = 0; i < candidateParams.length && i < baseParams.length; ++i) {
                m.put(baseParams[i], candidateSubstitutor.substitute(candidateParams[i]));
            }
            return factory.createSubstitutor((Map<PsiTypeParameter, PsiType>)m);
        }
        PsiSubstitutor substitutor = TypeConversionUtil.checkReferenceList(candidate.getExtendsListTypes(), candidateSubstitutor, base, visited, manager);
        if (substitutor == null) {
            substitutor = TypeConversionUtil.checkReferenceList(candidate.getImplementsListTypes(), candidateSubstitutor, base, visited, manager);
        }
        return substitutor;
    }

    private static PsiSubstitutor checkReferenceList(@NotNull PsiClassType[] types, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass base, @NotNull Set<PsiClass> set, @NotNull PsiManager manager) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/util/TypeConversionUtil", "checkReferenceList"));
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "checkReferenceList"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/util/TypeConversionUtil", "checkReferenceList"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/util/TypeConversionUtil", "checkReferenceList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/TypeConversionUtil", "checkReferenceList"));
        }
        for (PsiClassType type : types) {
            PsiSubstitutor substitutor;
            PsiSubstitutor newSubstitutor;
            PsiType substitutedType = candidateSubstitutor.substitute(type);
            LOG.assertTrue(substitutedType instanceof PsiClassType);
            PsiClassType.ClassResolveResult result = ((PsiClassType)substitutedType).resolveGenerics();
            PsiElement newCandidate = result.getElement();
            if (newCandidate == null || (newSubstitutor = TypeConversionUtil.getSuperClassSubstitutorInner(base, (PsiClass)newCandidate, substitutor = result.getSubstitutor(), set, manager)) == null) continue;
            return type.isRaw() ? JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createRawSubstitutor(base) : newSubstitutor;
        }
        return null;
    }

    @NotNull
    public static PsiType binaryNumericPromotion(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.isDoubleType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isDoubleType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
        }
        return psiPrimitiveType;
    }

    @NotNull
    private static PsiType unbox(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/TypeConversionUtil", "unbox"));
        }
        if (type instanceof PsiPrimitiveType) {
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unbox"));
            }
            return psiType;
        }
        if (type instanceof PsiClassType) {
            LOG.assertTrue((type = PsiPrimitiveType.getUnboxedType(type)) != null);
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unbox"));
            }
            return psiType;
        }
        LOG.error("Invalid type for unboxing " + type);
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unbox"));
        }
        return psiType;
    }

    public static boolean isIntegerNumber(String typeName) {
        return INTEGER_NUMBER_TYPES.contains(typeName);
    }

    public static boolean isPrimitive(String typeName) {
        return PRIMITIVE_TYPES.contains(typeName);
    }

    public static boolean isPrimitiveWrapper(String typeName) {
        return PRIMITIVE_WRAPPER_TYPES.contains(typeName);
    }

    @Contract(value="null -> false")
    public static boolean isAssignableFromPrimitiveWrapper(PsiType type) {
        if (type == null) {
            return false;
        }
        return TypeConversionUtil.isPrimitiveWrapper(type) || type.equalsToText("java.lang.Object") || type.equalsToText("java.lang.Number");
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveWrapper(PsiType type) {
        return type != null && TypeConversionUtil.isPrimitiveWrapper(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isComposite(PsiType type) {
        return type instanceof PsiDisjunctionType || type instanceof PsiIntersectionType;
    }

    public static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        return TypeConversionUtil.typeParameterErasure(typeParameter, PsiSubstitutor.EMPTY);
    }

    private static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor beforeSubstitutor) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        if (beforeSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                THashSet visited = new THashSet();
                visited.add(psiClass);
                PsiTypeParameter boundTypeParameter = (PsiTypeParameter)psiClass;
                if (beforeSubstitutor.getSubstitutionMap().containsKey(boundTypeParameter)) {
                    return TypeConversionUtil.erasure(beforeSubstitutor.substitute(boundTypeParameter));
                }
                return TypeConversionUtil.typeParameterErasureInner(boundTypeParameter, (Set<PsiClass>)visited, beforeSubstitutor);
            }
            if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private static PsiClassType typeParameterErasureInner(PsiTypeParameter typeParameter, Set<PsiClass> visited, PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                if (!visited.contains(psiClass)) {
                    visited.add(psiClass);
                    if (beforeSubstitutor.getSubstitutionMap().containsKey(psiClass)) {
                        return (PsiClassType)TypeConversionUtil.erasure(beforeSubstitutor.substitute((PsiTypeParameter)psiClass));
                    }
                    return TypeConversionUtil.typeParameterErasureInner((PsiTypeParameter)psiClass, visited, beforeSubstitutor);
                }
            } else if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @Contract(value="null -> null")
    public static PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure(type, PsiSubstitutor.EMPTY);
    }

    @Contract(value="null, _ -> null")
    public static PsiType erasure(@Nullable PsiType type, final @NotNull PsiSubstitutor beforeSubstitutor) {
        if (beforeSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeSubstitutor", "com/intellij/psi/util/TypeConversionUtil", "erasure"));
        }
        if (type == null) {
            return null;
        }
        return type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass instanceof PsiTypeParameter) {
                    return TypeConversionUtil.typeParameterErasure((PsiTypeParameter)aClass, beforeSubstitutor);
                }
                return classType.rawType();
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType.getExtendsBound().accept(this);
            }

            @Override
            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return ellipsisType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
                PsiClassType lub = PsiTypesUtil.getLowestUpperBoundClassType(disjunctionType);
                return lub != null ? TypeConversionUtil.erasure(lub, beforeSubstitutor) : disjunctionType;
            }
        });
    }

    public static Object computeCastTo(Object operand, PsiType castType) {
        Object value;
        if (operand == null || castType == null) {
            return null;
        }
        if (operand instanceof String && castType.equalsToText("java.lang.String")) {
            value = operand;
        } else if (operand instanceof Boolean && PsiType.BOOLEAN.equals(castType)) {
            value = operand;
        } else {
            PsiType primitiveType = TypeConversionUtil.wrapperToPrimitive(operand);
            if (primitiveType == null) {
                return null;
            }
            if (castType.equals(primitiveType)) {
                return operand;
            }
            int rankFrom = TypeConversionUtil.getTypeRank(primitiveType);
            if (rankFrom > caster.length) {
                return null;
            }
            int rankTo = TypeConversionUtil.getTypeRank(castType);
            if (rankTo > caster.length) {
                return null;
            }
            value = caster[rankFrom - 1][rankTo - 1].cast(operand);
        }
        return value;
    }

    @NotNull
    public static PsiType unboxAndBalanceTypes(PsiType type1, PsiType type2) {
        if (type1 instanceof PsiClassType) {
            type1 = PsiPrimitiveType.getUnboxedType(type1);
        }
        if (type2 instanceof PsiClassType) {
            type2 = PsiPrimitiveType.getUnboxedType(type2);
        }
        if (PsiType.DOUBLE.equals(type1) || PsiType.DOUBLE.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        if (PsiType.FLOAT.equals(type1) || PsiType.FLOAT.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        if (PsiType.LONG.equals(type1) || PsiType.LONG.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
        }
        return psiPrimitiveType;
    }

    public static IElementType convertEQtoOperation(IElementType eqOpSign) {
        IElementType opSign = null;
        if (eqOpSign == JavaTokenType.ANDEQ) {
            opSign = JavaTokenType.AND;
        } else if (eqOpSign == JavaTokenType.ASTERISKEQ) {
            opSign = JavaTokenType.ASTERISK;
        } else if (eqOpSign == JavaTokenType.DIVEQ) {
            opSign = JavaTokenType.DIV;
        } else if (eqOpSign == JavaTokenType.GTGTEQ) {
            opSign = JavaTokenType.GTGT;
        } else if (eqOpSign == JavaTokenType.GTGTGTEQ) {
            opSign = JavaTokenType.GTGTGT;
        } else if (eqOpSign == JavaTokenType.LTLTEQ) {
            opSign = JavaTokenType.LTLT;
        } else if (eqOpSign == JavaTokenType.MINUSEQ) {
            opSign = JavaTokenType.MINUS;
        } else if (eqOpSign == JavaTokenType.OREQ) {
            opSign = JavaTokenType.OR;
        } else if (eqOpSign == JavaTokenType.PERCEQ) {
            opSign = JavaTokenType.PERC;
        } else if (eqOpSign == JavaTokenType.PLUSEQ) {
            opSign = JavaTokenType.PLUS;
        } else if (eqOpSign == JavaTokenType.XOREQ) {
            opSign = JavaTokenType.XOR;
        }
        return opSign;
    }

    @Nullable
    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, @NotNull IElementType sign, boolean accessLType) {
        if (sign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/intellij/psi/util/TypeConversionUtil", "calcTypeForBinaryExpression"));
        }
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            return lType;
        }
        if (sign == JavaTokenType.EQEQ || sign == JavaTokenType.NE || sign == JavaTokenType.LT || sign == JavaTokenType.GT || sign == JavaTokenType.LE || sign == JavaTokenType.GE || sign == JavaTokenType.OROR || sign == JavaTokenType.ANDAND) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType(rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }

    public static boolean isFPZero(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/util/TypeConversionUtil", "isFPZero"));
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            char d = Character.toUpperCase(c);
            if (d == 'E' || d == 'P') break;
        }
        return true;
    }

    private static PsiType wrapperToPrimitive(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/util/TypeConversionUtil", "wrapperToPrimitive"));
        }
        return WRAPPER_TO_PRIMITIVE.get(o.getClass());
    }

    static {
        TYPE_TO_RANK_MAP.put((Object)PsiType.BYTE, 1);
        TYPE_TO_RANK_MAP.put((Object)PsiType.SHORT, 2);
        TYPE_TO_RANK_MAP.put((Object)PsiType.CHAR, 3);
        TYPE_TO_RANK_MAP.put((Object)PsiType.INT, 4);
        TYPE_TO_RANK_MAP.put((Object)PsiType.LONG, 5);
        TYPE_TO_RANK_MAP.put((Object)PsiType.FLOAT, 6);
        TYPE_TO_RANK_MAP.put((Object)PsiType.DOUBLE, 7);
        TYPE_TO_RANK_MAP.put((Object)PsiType.BOOLEAN, 10);
        POSSIBLE_BOXED_HOLDER_TYPES = Key.create((String)"Types that may be possibly assigned from primitive ones");
        ourGuard = RecursionManager.createGuard((String)"isAssignable");
        ourReportedSuperClassSubstitutorExceptions = new ConcurrentHashSet();
        INTEGER_NUMBER_TYPES = new THashSet(5);
        INTEGER_NUMBER_TYPES.add(PsiType.BYTE.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.CHAR.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.LONG.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.INT.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES = new THashSet(9);
        PRIMITIVE_TYPES.add(PsiType.VOID.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BYTE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.CHAR.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.DOUBLE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.FLOAT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.LONG.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.INT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BOOLEAN.getCanonicalText());
        PRIMITIVE_WRAPPER_TYPES = new THashSet(8);
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Byte");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Character");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Double");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Float");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Long");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Integer");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Short");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Boolean");
        caster = new Caster[][]{{new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$6", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$6", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$7", "cast"));
                }
                Short s = (short)((Number)operand).intValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$7", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$8", "cast"));
                }
                Character c = Character.valueOf((char)((Number)operand).intValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$8", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$9", "cast"));
                }
                Integer n = ((Number)operand).intValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$9", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$10", "cast"));
                }
                Long l = ((Number)operand).intValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$10", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$11", "cast"));
                }
                Float f = Float.valueOf(((Number)operand).intValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$11", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$12", "cast"));
                }
                Double d = ((Number)operand).intValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$12", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$13", "cast"));
                }
                Byte by = (byte)((Short)operand).shortValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$13", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$14", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$14", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$15", "cast"));
                }
                Character c = Character.valueOf((char)((Short)operand).shortValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$15", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$16", "cast"));
                }
                Integer n = (int)((Short)operand);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$16", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$17", "cast"));
                }
                Long l = (long)((Short)operand);
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$17", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$18", "cast"));
                }
                Float f = Float.valueOf(((Short)operand).shortValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$18", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$19", "cast"));
                }
                Double d = (double)((Short)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$19", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$20", "cast"));
                }
                Byte by = (byte)((Character)operand).charValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$20", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$21", "cast"));
                }
                Short s = (short)((Character)operand).charValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$21", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$22", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$22", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$23", "cast"));
                }
                Integer n = ((Character)operand).charValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$23", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$24", "cast"));
                }
                Long l = ((Character)operand).charValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$24", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$25", "cast"));
                }
                Float f = Float.valueOf(((Character)operand).charValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$25", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$26", "cast"));
                }
                Double d = ((Character)operand).charValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$26", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$27", "cast"));
                }
                Byte by = (byte)((Integer)operand).intValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$27", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$28", "cast"));
                }
                Short s = (short)((Integer)operand).intValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$28", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$29", "cast"));
                }
                Character c = Character.valueOf((char)((Integer)operand).intValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$29", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$30", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$30", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$31", "cast"));
                }
                Long l = (long)((Integer)operand);
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$31", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$32", "cast"));
                }
                Float f = Float.valueOf(((Integer)operand).intValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$32", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$33", "cast"));
                }
                Double d = (double)((Integer)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$33", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$34", "cast"));
                }
                Byte by = (byte)((Long)operand).longValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$34", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$35", "cast"));
                }
                Short s = (short)((Long)operand).longValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$35", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$36", "cast"));
                }
                Character c = Character.valueOf((char)((Long)operand).longValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$36", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$37", "cast"));
                }
                Integer n = (int)((Long)operand).longValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$37", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$38", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$38", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$39", "cast"));
                }
                Float f = Float.valueOf(((Long)operand).longValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$39", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$40", "cast"));
                }
                Double d = (double)((Long)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$40", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$41", "cast"));
                }
                Byte by = (byte)((Float)operand).floatValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$41", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$42", "cast"));
                }
                Short s = (short)((Float)operand).floatValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$42", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$43", "cast"));
                }
                Character c = Character.valueOf((char)((Float)operand).floatValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$43", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$44", "cast"));
                }
                Integer n = (int)((Float)operand).floatValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$44", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$45", "cast"));
                }
                Long l = (long)((Float)operand).floatValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$45", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$46", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$46", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$47", "cast"));
                }
                Double d = ((Float)operand).floatValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$47", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$48", "cast"));
                }
                Byte by = (byte)((Double)operand).doubleValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$48", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$49", "cast"));
                }
                Short s = (short)((Double)operand).doubleValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$49", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$50", "cast"));
                }
                Character c = Character.valueOf((char)((Double)operand).doubleValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$50", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$51", "cast"));
                }
                Integer n = (int)((Double)operand).doubleValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$51", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$52", "cast"));
                }
                Long l = (long)((Double)operand).doubleValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$52", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$53", "cast"));
                }
                Float f = new Float((Double)operand);
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$53", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/psi/util/TypeConversionUtil$54", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$54", "cast"));
                }
                return object;
            }
        }}};
        WRAPPER_TO_PRIMITIVE = new THashMap(8);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, PsiType.BOOLEAN);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, PsiType.BYTE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, PsiType.CHAR);
        WRAPPER_TO_PRIMITIVE.put(Short.class, PsiType.SHORT);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, PsiType.INT);
        WRAPPER_TO_PRIMITIVE.put(Long.class, PsiType.LONG);
        WRAPPER_TO_PRIMITIVE.put(Float.class, PsiType.FLOAT);
        WRAPPER_TO_PRIMITIVE.put(Double.class, PsiType.DOUBLE);
    }

    private static class WildcardDetector
    extends PsiTypeVisitor<Boolean> {
        private WildcardDetector() {
        }

        @Override
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return true;
        }

        @Override
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            return true;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiType[] parameters;
            for (PsiType parameter : parameters = classType.getParameters()) {
                if (!parameter.accept(this).booleanValue()) continue;
                return true;
            }
            return (Boolean)super.visitClassType(classType);
        }

        @Override
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        @Nullable
        public Boolean visitIntersectionType(PsiIntersectionType intersectionType) {
            for (PsiType psiType : intersectionType.getConjuncts()) {
                if (!psiType.accept(this).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }
    }

    private static interface Caster {
        @NotNull
        public Object cast(@NotNull Object var1);
    }
}

