/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ImportNSAction
implements QuestionAction {
    private final Set<String> myNamespaces;
    private final XmlFile myFile;
    private final PsiElement myElement;
    private final Editor myEditor;
    private final String myTitle;

    public ImportNSAction(Set<String> namespaces, XmlFile file, @NotNull PsiElement element, Editor editor, String title) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ImportNSAction", "<init>"));
        }
        this.myNamespaces = namespaces;
        this.myFile = file;
        this.myElement = element;
        this.myEditor = editor;
        this.myTitle = title;
    }

    public boolean execute() {
        Object[] objects = this.myNamespaces.toArray();
        Arrays.sort(objects);
        JBList list = new JBList(objects);
        list.setCellRenderer(XmlNSRenderer.INSTANCE);
        list.setSelectedIndex(0);
        int offset = this.myElement.getTextOffset();
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
        Runnable runnable = new Runnable((JList)list, marker){
            final /* synthetic */ JList val$list;
            final /* synthetic */ RangeMarker val$marker;
            {
                this.val$list = jList;
                this.val$marker = rangeMarker;
            }

            @Override
            public void run() {
                final String namespace = (String)this.val$list.getSelectedValue();
                if (namespace != null) {
                    Project project = ImportNSAction.this.myFile.getProject();
                    new WriteCommandAction.Simple(project, new PsiFile[]{ImportNSAction.this.myFile}){

                        protected void run() throws Throwable {
                            final XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)ImportNSAction.this.myFile);
                            String prefix = extension.getNamespacePrefix(ImportNSAction.this.myElement);
                            extension.insertNamespaceDeclaration(ImportNSAction.this.myFile, ImportNSAction.this.myEditor, Collections.singleton(namespace), prefix, new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                                @Override
                                public void run(String s) throws IncorrectOperationException {
                                    PsiDocumentManager.getInstance((Project)ImportNSAction.this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(ImportNSAction.this.myEditor.getDocument());
                                    PsiElement element = ImportNSAction.this.myFile.findElementAt(val$marker.getStartOffset());
                                    if (element != null) {
                                        extension.qualifyWithPrefix(s, element, ImportNSAction.this.myEditor.getDocument());
                                    }
                                }
                            });
                        }
                    }.execute();
                }
            }
        };
        if (list.getModel().getSize() == 1) {
            runnable.run();
        } else {
            new PopupChooserBuilder((JList)list).setTitle(this.myTitle).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(this.myEditor);
        }
        return true;
    }
}

