/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import org.jetbrains.annotations.NotNull;

public class JavaCreateFieldFromUsageHelper
extends CreateFieldFromUsageHelper {
    @Override
    public Template setupTemplateImpl(PsiField field, Object expectedTypes, PsiClass targetClass, Editor editor, PsiElement context, boolean createConstantField, PsiSubstitutor substitutor) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)field.getProject());
        field = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(field);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)field);
        if (!(expectedTypes instanceof ExpectedTypeInfo[])) {
            expectedTypes = ExpectedTypeInfo.EMPTY_ARRAY;
        }
        new GuessTypeParameters((JVMElementFactory)factory).setupTypeElement(field.getTypeElement(), expectedTypes, substitutor, builder, context, targetClass);
        if (createConstantField) {
            field.setInitializer(factory.createExpressionFromText("0", null));
            builder.replaceElement((PsiElement)field.getInitializer(), (Expression)new EmptyExpression());
            PsiIdentifier identifier = field.getNameIdentifier();
            builder.setEndVariableAfter((PsiElement)identifier);
            field = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(field);
        }
        editor.getCaretModel().moveToOffset(field.getTextRange().getStartOffset());
        Template template = builder.buildInlineTemplate();
        if (expectedTypes.length > 1) {
            template.setToShortenLongNames(false);
        }
        return template;
    }

    @Override
    public PsiField insertFieldImpl(@NotNull PsiClass targetClass, @NotNull PsiField field, @NotNull PsiElement place) {
        PsiClass parentClass;
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/codeInsight/daemon/impl/quickfix/JavaCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/JavaCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/quickfix/JavaCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        PsiMember enclosingContext = null;
        while ((parentClass = (enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(enclosingContext == null ? place : enclosingContext), (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class})) == null ? null : enclosingContext.getContainingClass()) instanceof PsiAnonymousClass) {
        }
        return BaseExpressionToFieldHandler.ConvertToFieldRunnable.appendField(targetClass, field, (PsiElement)enclosingContext, null);
    }
}

