/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaBreakpointProperties>
implements JavaBreakpointType {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @Nullable
    public JavaBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public Breakpoint createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        LineBreakpoint lineBreakpoint = new LineBreakpoint(project, breakpoint);
        if (lineBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createJavaBreakpoint"));
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }
}

